/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.subscribe;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.eventengine.EffectDispatcher;
import com.pubnub.internal.eventengine.Event;
import com.pubnub.internal.eventengine.EventEngine;
import com.pubnub.internal.eventengine.EventEngineManager;
import com.pubnub.internal.managers.ListenerManager;
import com.pubnub.internal.presence.eventengine.data.PresenceData;
import com.pubnub.internal.subscribe.eventengine.SubscribeEventEngineKt;
import com.pubnub.internal.subscribe.eventengine.configuration.EventEnginesConf;
import com.pubnub.internal.subscribe.eventengine.data.SubscriptionData;
import com.pubnub.internal.subscribe.eventengine.effect.SubscribeEffectFactory;
import com.pubnub.internal.subscribe.eventengine.effect.SubscribeEffectInvocation;
import com.pubnub.internal.subscribe.eventengine.effect.effectprovider.HandshakeProviderImpl;
import com.pubnub.internal.subscribe.eventengine.effect.effectprovider.ReceiveMessagesProviderImpl;
import com.pubnub.internal.subscribe.eventengine.event.SubscribeEvent;
import com.pubnub.internal.subscribe.eventengine.event.SubscriptionCursor;
import com.pubnub.internal.subscribe.eventengine.state.SubscribeState;
import com.pubnub.internal.workers.SubscribeMessageProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)BQ\u00128\u0010\u0002\u001a4\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0007j\u0002`\b0\u0003j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0018\u001a\u00020\u0010J\u0006\u0010\u0019\u001a\u00020\u0010J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bJ\u0010\u0010\u001d\u001a\u00020\u00102\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0010H\u0002J\b\u0010!\u001a\u00020\u0010H\u0002J\u0016\u0010\"\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010#\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J4\u0010$\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010%\u001a\u00020\u001fJ$\u0010&\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J&\u0010'\u001a\u00020\u00102\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010(\u001a\u00020\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0002\u001a4\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0007j\u0002`\b0\u0003j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pubnub/internal/subscribe/Subscribe;", "", "subscribeEventEngineManager", "Lcom/pubnub/internal/eventengine/EventEngineManager;", "Lcom/pubnub/internal/subscribe/eventengine/effect/SubscribeEffectInvocation;", "Lcom/pubnub/internal/subscribe/eventengine/event/SubscribeEvent;", "Lcom/pubnub/internal/subscribe/eventengine/state/SubscribeState;", "Lcom/pubnub/internal/eventengine/EventEngine;", "Lcom/pubnub/internal/subscribe/eventengine/SubscribeEventEngine;", "Lcom/pubnub/internal/managers/SubscribeEventEngineManager;", "presenceData", "Lcom/pubnub/internal/presence/eventengine/data/PresenceData;", "subscriptionData", "Lcom/pubnub/internal/subscribe/eventengine/data/SubscriptionData;", "(Lcom/pubnub/internal/eventengine/EventEngineManager;Lcom/pubnub/internal/presence/eventengine/data/PresenceData;Lcom/pubnub/internal/subscribe/eventengine/data/SubscriptionData;)V", "addChannelGroupsToSubscriptionData", "", "channelGroups", "", "", "withPresence", "", "addChannelsToSubscriptionData", "channels", "destroy", "disconnect", "getSubscribedChannelGroups", "", "getSubscribedChannels", "reconnect", "timetoken", "", "removeAllChannelGroupsFromLocalStorage", "removeAllChannelsFromLocalStorage", "removeChannelGroupsFromSubscriptionData", "removeChannelsFromSubscriptionData", "subscribe", "withTimetoken", "throwExceptionIfChannelAndChannelGroupIsMissing", "unsubscribe", "unsubscribeAll", "Companion", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nSubscribe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Subscribe.kt\ncom/pubnub/internal/subscribe/Subscribe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n766#2:249\n857#2,2:250\n766#2:252\n857#2,2:253\n1855#2,2:255\n1855#2,2:257\n1855#2,2:259\n1855#2,2:261\n*S KotlinDebug\n*F\n+ 1 Subscribe.kt\ncom/pubnub/internal/subscribe/Subscribe\n*L\n161#1:249\n161#1:250,2\n166#1:252\n166#1:253,2\n204#1:255,2\n217#1:257,2\n225#1:259,2\n233#1:261,2\n*E\n"})
public final class Subscribe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager;
    @NotNull
    private final PresenceData presenceData;
    @NotNull
    private final SubscriptionData subscriptionData;

    public Subscribe(@NotNull EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager, @NotNull PresenceData presenceData, @NotNull SubscriptionData subscriptionData) {
        Intrinsics.checkNotNullParameter(subscribeEventEngineManager, (String)"subscribeEventEngineManager");
        Intrinsics.checkNotNullParameter((Object)presenceData, (String)"presenceData");
        Intrinsics.checkNotNullParameter((Object)subscriptionData, (String)"subscriptionData");
        this.subscribeEventEngineManager = subscribeEventEngineManager;
        this.presenceData = presenceData;
        this.subscriptionData = subscriptionData;
    }

    public /* synthetic */ Subscribe(EventEngineManager eventEngineManager, PresenceData presenceData, SubscriptionData subscriptionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            subscriptionData = new SubscriptionData();
        }
        this(eventEngineManager, presenceData, subscriptionData);
    }

    public final synchronized void subscribe(@NotNull Set<String> channels, @NotNull Set<String> channelGroups, boolean withPresence, long withTimetoken) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        this.throwExceptionIfChannelAndChannelGroupIsMissing(channels, channelGroups);
        this.addChannelsToSubscriptionData(channels, withPresence);
        this.addChannelGroupsToSubscriptionData(channelGroups, withPresence);
        Set<String> channelsInLocalStorage = this.subscriptionData.getChannels$pubnub_core_impl();
        Set<String> channelGroupsInLocalStorage = this.subscriptionData.getChannelGroups$pubnub_core_impl();
        if (withTimetoken != 0L) {
            SubscribeEvent.SubscriptionRestored subscriptionRestoredEvent = new SubscribeEvent.SubscriptionRestored(channelsInLocalStorage, channelGroupsInLocalStorage, new SubscriptionCursor(withTimetoken, null));
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)subscriptionRestoredEvent));
        } else {
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)new SubscribeEvent.SubscriptionChanged(channelsInLocalStorage, channelGroupsInLocalStorage)));
        }
    }

    public static /* synthetic */ void subscribe$default(Subscribe subscribe2, Set set, Set set2, boolean bl, long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = 0L;
        }
        subscribe2.subscribe(set, set2, bl, l);
    }

    public final synchronized void unsubscribe(@NotNull Set<String> channels, @NotNull Set<String> channelGroups) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        this.throwExceptionIfChannelAndChannelGroupIsMissing(channels, channelGroups);
        this.removeChannelsFromSubscriptionData(channels);
        this.removeChannelGroupsFromSubscriptionData(channelGroups);
        ((ConcurrentHashMap.KeySetView)this.presenceData.getChannelStates$pubnub_core_impl().keySet()).removeAll(channels);
        if (this.subscriptionData.getChannels$pubnub_core_impl().size() > 0 || this.subscriptionData.getChannelGroups$pubnub_core_impl().size() > 0) {
            Set<String> channelsInLocalStorage = this.subscriptionData.getChannels$pubnub_core_impl();
            Set<String> channelGroupsInLocalStorage = this.subscriptionData.getChannelGroups$pubnub_core_impl();
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)new SubscribeEvent.SubscriptionChanged(channelsInLocalStorage, channelGroupsInLocalStorage)));
        } else {
            this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.UnsubscribeAll.INSTANCE));
        }
    }

    public static /* synthetic */ void unsubscribe$default(Subscribe subscribe2, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        subscribe2.unsubscribe(set, set2);
    }

    public final synchronized void unsubscribeAll() {
        this.removeAllChannelsFromLocalStorage();
        this.removeAllChannelGroupsFromLocalStorage();
        this.presenceData.getChannelStates$pubnub_core_impl().clear();
        this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.UnsubscribeAll.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<String> getSubscribedChannels() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)this.subscriptionData.getChannels$pubnub_core_impl());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.endsWith$default((String)it, (String)"-pnpres", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<String> getSubscribedChannelGroups() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)this.subscriptionData.getChannelGroups$pubnub_core_impl());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.endsWith$default((String)it, (String)"-pnpres", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void disconnect() {
        this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)SubscribeEvent.Disconnect.INSTANCE));
    }

    public final void reconnect(long timetoken) {
        SubscribeEvent.Reconnect event = timetoken != 0L ? new SubscribeEvent.Reconnect(new SubscriptionCursor(timetoken, null)) : new SubscribeEvent.Reconnect(null, 1, null);
        this.subscribeEventEngineManager.addEventToQueue((SubscribeEvent)((Event)event));
    }

    public static /* synthetic */ void reconnect$default(Subscribe subscribe2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        subscribe2.reconnect(l);
    }

    public final synchronized void destroy() {
        this.disconnect();
        this.subscribeEventEngineManager.stop();
    }

    private final void throwExceptionIfChannelAndChannelGroupIsMissing(Set<String> channels, Set<String> channelGroups) {
        if (channels.isEmpty() && channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_OR_CHANNEL_GROUP_MISSING);
        }
    }

    private final void addChannelsToSubscriptionData(Set<String> channels, boolean withPresence) {
        this.subscriptionData.getChannels$pubnub_core_impl().addAll((Collection<String>)channels);
        if (withPresence) {
            Iterable $this$forEach$iv = channels;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String presenceChannel = it + "-pnpres";
                this.subscriptionData.getChannels$pubnub_core_impl().add(presenceChannel);
            }
        }
    }

    private final void addChannelGroupsToSubscriptionData(Set<String> channelGroups, boolean withPresence) {
        this.subscriptionData.getChannelGroups$pubnub_core_impl().addAll((Collection<String>)channelGroups);
        if (withPresence) {
            Iterable $this$forEach$iv = channelGroups;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String presenceChannelGroup = it + "-pnpres";
                this.subscriptionData.getChannelGroups$pubnub_core_impl().add(presenceChannelGroup);
            }
        }
    }

    private final void removeChannelGroupsFromSubscriptionData(Set<String> channelGroups) {
        Iterable $this$forEach$iv = channelGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.subscriptionData.getChannelGroups$pubnub_core_impl().remove(it);
            String presenceChannelGroup = it + "-pnpres";
            this.subscriptionData.getChannelGroups$pubnub_core_impl().remove(presenceChannelGroup);
        }
    }

    private final void removeChannelsFromSubscriptionData(Set<String> channels) {
        Iterable $this$forEach$iv = channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.subscriptionData.getChannels$pubnub_core_impl().remove(it);
            String presenceChannel = it + "-pnpres";
            this.subscriptionData.getChannels$pubnub_core_impl().remove(presenceChannel);
        }
    }

    private final void removeAllChannelsFromLocalStorage() {
        this.subscriptionData.getChannels$pubnub_core_impl().clear();
    }

    private final void removeAllChannelGroupsFromLocalStorage() {
        this.subscriptionData.getChannelGroups$pubnub_core_impl().clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011Jj\u0010\u0012\u001a4\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0017j\u0002`\u00180\u0013j\u0002`\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/pubnub/internal/subscribe/Subscribe$Companion;", "", "()V", "create", "Lcom/pubnub/internal/subscribe/Subscribe;", "pubNub", "Lcom/pubnub/internal/PubNubCore;", "listenerManager", "Lcom/pubnub/internal/managers/ListenerManager;", "eventEnginesConf", "Lcom/pubnub/internal/subscribe/eventengine/configuration/EventEnginesConf;", "messageProcessor", "Lcom/pubnub/internal/workers/SubscribeMessageProcessor;", "presenceData", "Lcom/pubnub/internal/presence/eventengine/data/PresenceData;", "sendStateWithSubscribe", "", "create$pubnub_core_impl", "createAndStartSubscribeEventEngineManager", "Lcom/pubnub/internal/eventengine/EventEngineManager;", "Lcom/pubnub/internal/subscribe/eventengine/effect/SubscribeEffectInvocation;", "Lcom/pubnub/internal/subscribe/eventengine/event/SubscribeEvent;", "Lcom/pubnub/internal/subscribe/eventengine/state/SubscribeState;", "Lcom/pubnub/internal/eventengine/EventEngine;", "Lcom/pubnub/internal/subscribe/eventengine/SubscribeEventEngine;", "Lcom/pubnub/internal/managers/SubscribeEventEngineManager;", "pubnub-core-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Subscribe create$pubnub_core_impl(@NotNull PubNubCore pubNub, @NotNull ListenerManager listenerManager, @NotNull EventEnginesConf eventEnginesConf, @NotNull SubscribeMessageProcessor messageProcessor, @NotNull PresenceData presenceData, boolean sendStateWithSubscribe) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
            Intrinsics.checkNotNullParameter((Object)eventEnginesConf, (String)"eventEnginesConf");
            Intrinsics.checkNotNullParameter((Object)messageProcessor, (String)"messageProcessor");
            Intrinsics.checkNotNullParameter((Object)presenceData, (String)"presenceData");
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager = this.createAndStartSubscribeEventEngineManager(pubNub, messageProcessor, eventEnginesConf, listenerManager, presenceData, sendStateWithSubscribe);
            return new Subscribe(subscribeEventEngineManager, presenceData, null, 4, null);
        }

        private final EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> createAndStartSubscribeEventEngineManager(PubNubCore pubNub, SubscribeMessageProcessor messageProcessor, EventEnginesConf eventEnginesConf, ListenerManager listenerManager, PresenceData presenceData, boolean sendStateWithSubscribe) {
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> eventEngineManager;
            SubscribeEffectFactory subscribeEffectFactory = new SubscribeEffectFactory(new HandshakeProviderImpl(pubNub), new ReceiveMessagesProviderImpl(pubNub, messageProcessor), eventEnginesConf.getSubscribe().getEventSink(), listenerManager, listenerManager, presenceData, sendStateWithSubscribe);
            EventEngine subscribeEventEngine = SubscribeEventEngineKt.SubscribeEventEngine$default(eventEnginesConf.getSubscribe().getEffectSink(), eventEnginesConf.getSubscribe().getEventSource(), null, 4, null);
            EffectDispatcher subscribeEffectDispatcher = new EffectDispatcher(subscribeEffectFactory, eventEnginesConf.getSubscribe().getEffectSource(), null, null, 12, null);
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> $this$createAndStartSubscribeEventEngineManager_u24lambda_u240 = eventEngineManager = new EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>>(subscribeEventEngine, subscribeEffectDispatcher, eventEnginesConf.getSubscribe().getEventSink());
            boolean bl = false;
            $this$createAndStartSubscribeEventEngineManager_u24lambda_u240.start();
            EventEngineManager<SubscribeEffectInvocation, SubscribeEvent, SubscribeState, EventEngine<SubscribeEffectInvocation, SubscribeEvent, SubscribeState>> subscribeEventEngineManager = eventEngineManager;
            return subscribeEventEngineManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

