/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.remoteaction;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.v2.callbacks.Result;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0016B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\r\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\rH\u0002R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/pubnub/internal/endpoints/remoteaction/RetryingRemoteAction;", "T", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "remoteAction", "maxNumberOfAutomaticRetries", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;ILjava/util/concurrent/ExecutorService;)V", "cachedCallback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "async", "", "callback", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "retry", "silentCancel", "sync", "()Ljava/lang/Object;", "validate", "Companion", "pubnub-core-impl"})
public final class RetryingRemoteAction<T>
implements ExtendedRemoteAction<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtendedRemoteAction<T> remoteAction;
    private final int maxNumberOfAutomaticRetries;
    @NotNull
    private final ExecutorService executorService;
    private Consumer<Result<T>> cachedCallback;

    public RetryingRemoteAction(@NotNull ExtendedRemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(remoteAction, (String)"remoteAction");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.remoteAction = remoteAction;
        this.maxNumberOfAutomaticRetries = maxNumberOfAutomaticRetries;
        this.executorService = executorService;
    }

    public T sync() throws PubNubException {
        this.validate();
        PubNubException thrownException = null;
        int n = this.maxNumberOfAutomaticRetries;
        for (int i = 0; i < n; ++i) {
            try {
                return (T)this.remoteAction.sync();
            }
            catch (Throwable ex) {
                thrownException = PubNubException.Companion.from(ex);
                continue;
            }
        }
        PubNubException pubNubException = thrownException;
        Intrinsics.checkNotNull(pubNubException);
        throw pubNubException;
    }

    public void async(@NotNull Consumer<Result<T>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.cachedCallback = callback;
        this.executorService.execute(() -> RetryingRemoteAction.async$lambda$0(this, callback));
    }

    public void retry() {
        Consumer<Result<Result<T>>> consumer = this.cachedCallback;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCallback");
            consumer = null;
        }
        this.async(consumer);
    }

    public void silentCancel() {
        this.remoteAction.silentCancel();
    }

    @NotNull
    public PNOperationType operationType() {
        return this.remoteAction.operationType();
    }

    private final void validate() throws PubNubException {
        if (this.maxNumberOfAutomaticRetries < 1) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
    }

    private static final void async$lambda$0(RetryingRemoteAction this$0, Consumer $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        try {
            this$0.validate();
        }
        catch (PubNubException ex) {
            $callback.accept(Result.Companion.failure(ex));
            return;
        }
        Throwable lastException = null;
        int n = this$0.maxNumberOfAutomaticRetries;
        for (int i = 0; i < n; ++i) {
            try {
                $callback.accept(Result.Companion.success(this$0.remoteAction.sync()));
                continue;
            }
            catch (Throwable e) {
                lastException = e;
            }
        }
        Throwable throwable = lastException;
        Intrinsics.checkNotNull((Object)throwable);
        $callback.accept(Result.Companion.failure(PubNubException.copy$default((PubNubException)PubNubException.Companion.from(throwable), null, null, null, (int)0, null, null, null, null, null, null, (ExtendedRemoteAction)this$0, (int)1023, null)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/pubnub/internal/endpoints/remoteaction/RetryingRemoteAction$Companion;", "", "()V", "autoRetry", "Lcom/pubnub/internal/endpoints/remoteaction/RetryingRemoteAction;", "T", "remoteAction", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "maxNumberOfAutomaticRetries", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "pubnub-core-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> RetryingRemoteAction<T> autoRetry(@NotNull ExtendedRemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, @NotNull ExecutorService executorService) {
            Intrinsics.checkNotNullParameter(remoteAction, (String)"remoteAction");
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            return new RetryingRemoteAction<T>(remoteAction, maxNumberOfAutomaticRetries, executorService);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

