/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.push;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushListProvisionsResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.push.ListPushProvisionsInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B5\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u00042\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001cH\u0014J8\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001e2\"\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001fj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003` H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0017H\u0014R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/pubnub/internal/endpoints/push/ListPushProvisionsEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/push/PNPushListProvisionsResult;", "Lcom/pubnub/internal/endpoints/push/ListPushProvisionsInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "pushType", "Lcom/pubnub/api/enums/PNPushType;", "deviceId", "topic", "environment", "Lcom/pubnub/api/enums/PNPushEnvironment;", "(Lcom/pubnub/internal/PubNubCore;Lcom/pubnub/api/enums/PNPushType;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/enums/PNPushEnvironment;)V", "getDeviceId", "()Ljava/lang/String;", "getEnvironment", "()Lcom/pubnub/api/enums/PNPushEnvironment;", "getPushType", "()Lcom/pubnub/api/enums/PNPushType;", "getTopic", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNPushNotificationEnabledChannelsOperation;", "validateParams", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nListPushProvisionsEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListPushProvisionsEndpoint.kt\ncom/pubnub/internal/endpoints/push/ListPushProvisionsEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ListPushProvisionsEndpoint
extends EndpointCore<List<? extends String>, PNPushListProvisionsResult>
implements ListPushProvisionsInterface {
    @NotNull
    private final PNPushType pushType;
    @NotNull
    private final String deviceId;
    @Nullable
    private final String topic;
    @NotNull
    private final PNPushEnvironment environment;

    public ListPushProvisionsEndpoint(@NotNull PubNubCore pubnub, @NotNull PNPushType pushType, @NotNull String deviceId, @Nullable String topic, @NotNull PNPushEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)pushType, (String)"pushType");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(pubnub);
        this.pushType = pushType;
        this.deviceId = deviceId;
        this.topic = topic;
        this.environment = environment;
    }

    public /* synthetic */ ListPushProvisionsEndpoint(PubNubCore pubNubCore, PNPushType pNPushType, String string, String string2, PNPushEnvironment pNPushEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            pNPushEnvironment = PNPushEnvironment.DEVELOPMENT;
        }
        this(pubNubCore, pNPushType, string, string2, pNPushEnvironment);
    }

    @Override
    @NotNull
    public PNPushType getPushType() {
        return this.pushType;
    }

    @Override
    @NotNull
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public PNPushEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected void validateParams() {
        CharSequence charSequence;
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getDeviceId())) {
            throw new PubNubException(PubNubError.DEVICE_ID_MISSING);
        }
        if (this.getPushType() == PNPushType.APNS2 && ((charSequence = (CharSequence)this.getTopic()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            throw new PubNubException(PubNubError.PUSH_TOPIC_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<List<String>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPushType() != PNPushType.APNS2 ? this.getRetrofitManager().getPushService$pubnub_core_impl().listChannelsForDevice(this.getConfiguration().getSubscribeKey(), this.getDeviceId(), (Map<String, String>)queryParams) : this.getRetrofitManager().getPushService$pubnub_core_impl().listChannelsForDeviceApns2(this.getConfiguration().getSubscribeKey(), this.getDeviceId(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPushListProvisionsResult createResponse(@NotNull Response<List<String>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPushListProvisionsResult((List)object);
    }

    @NotNull
    public PNOperationType.PNPushNotificationEnabledChannelsOperation operationType() {
        return PNOperationType.PNPushNotificationEnabledChannelsOperation;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block1: {
            if (this.getPushType() != PNPushType.APNS2) {
                queryParams.put("type", this.getPushType().toParamString());
                return;
            }
            Map<String, String> map = queryParams;
            String string = "environment";
            String string2 = this.getEnvironment().name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            string2 = string3;
            map.put(string, string2);
            String string4 = this.getTopic();
            if (string4 == null) break block1;
            String $this$addQueryParams_u24lambda_u240 = string4;
            boolean bl = false;
            queryParams.put("topic", $this$addQueryParams_u24lambda_u240);
        }
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUSH_NOTIFICATION;
    }
}

