/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.history.PNMessageCountResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.endpoints.MessageCountsInterface;
import com.pubnub.internal.managers.MapperManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B+\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0019j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u001aH\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/pubnub/internal/endpoints/MessageCountsEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/history/PNMessageCountResult;", "Lcom/pubnub/internal/endpoints/MessageCountsInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channels", "", "", "channelsTimetoken", "", "(Lcom/pubnub/internal/PubNubCore;Ljava/util/List;Ljava/util/List;)V", "getChannels", "()Ljava/util/List;", "getChannelsTimetoken", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNMessageCountOperation;", "validateParams", "pubnub-core-impl"})
public final class MessageCountsEndpoint
extends EndpointCore<JsonElement, PNMessageCountResult>
implements MessageCountsInterface {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<Long> channelsTimetoken;

    public MessageCountsEndpoint(@NotNull PubNubCore pubnub, @NotNull List<String> channels, @NotNull List<Long> channelsTimetoken) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelsTimetoken, (String)"channelsTimetoken");
        super(pubnub);
        this.channels = channels;
        this.channelsTimetoken = channelsTimetoken;
    }

    @Override
    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    public List<Long> getChannelsTimetoken() {
        return this.channelsTimetoken;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.getChannelsTimetoken().isEmpty()) {
            throw new PubNubException(PubNubError.TIMETOKEN_MISSING);
        }
        if (this.getChannelsTimetoken().size() != this.getChannels().size() && this.getChannelsTimetoken().size() > 1) {
            throw new PubNubException(PubNubError.CHANNELS_TIMETOKEN_MISMATCH);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected Call<JsonElement> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getHistoryService$pubnub_core_impl().fetchCount(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNMessageCountResult createResponse(@NotNull Response<JsonElement> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        HashMap channelsMap = new HashMap();
        MapperManager mapperManager = this.getPubnub().getMapper();
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator((JsonElement)object, "channels");
        while (it.hasNext()) {
            String string;
            Map.Entry<String, JsonElement> entry = it.next();
            Map map = channelsMap;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"entry.key");
            Long l = entry.getValue().getAsLong();
            map.put(string, l);
        }
        return new PNMessageCountResult((Map)channelsMap);
    }

    @NotNull
    public PNOperationType.PNMessageCountOperation operationType() {
        return PNOperationType.PNMessageCountOperation;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (this.getChannelsTimetoken().size() == 1) {
            queryParams.put("timetoken", PubNubUtilKt.toCsv(this.getChannelsTimetoken()));
        } else {
            queryParams.put("channelsTimetoken", PubNubUtilKt.toCsv(this.getChannelsTimetoken()));
        }
    }
}

