/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal;

import com.pubnub.api.PubNubException;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.internal.vendor.Base64;
import com.pubnub.internal.vendor.Crypto;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J0\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J!\u0010\u0018\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eH\u0000\u00a2\u0006\u0002\b\u001aJ\u001f\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J!\u0010 \u001a\u00020\u00042\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040#H\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u001e\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004J\u0017\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b,J\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/J\u001e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b6J\u0012\u00107\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/pubnub/internal/PubNubUtil;", "", "()V", "AUTH_QUERY_PARAM_NAME", "", "CHARSET", "SIGNATURE_QUERY_PARAM_NAME", "TIMESTAMP_QUERY_PARAM_NAME", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generateSignature", "requestURL", "queryParams", "", "method", "requestBody", "timestamp", "", "subscribeKey", "publishKey", "secretKey", "request", "Lokhttp3/Request;", "maybeAddEeQueryParam", "", "maybeAddEeQueryParam$pubnub_core_impl", "pamEncode", "stringToEncode", "alreadyPercentEncoded", "", "pamEncode$pubnub_core_impl", "preparePamArguments", "encodedQueryString", "pamArgs", "", "preparePamArguments$pubnub_core_impl", "removeTrailingEqualSigns", "signature", "replaceLast", "string", "toReplace", "replacement", "requestBodyToString", "requestBodyToString$pubnub_core_impl", "shouldSignRequest", "configuration", "Lcom/pubnub/api/v2/BasePNConfiguration;", "signRequest", "originalRequest", "pnConfiguration", "signSHA256", "key", "data", "signSHA256$pubnub_core_impl", "urlDecode", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nPubNubUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PubNubUtil.kt\ncom/pubnub/internal/PubNubUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1549#2:271\n1620#2,3:272\n*S KotlinDebug\n*F\n+ 1 PubNubUtil.kt\ncom/pubnub/internal/PubNubUtil\n*L\n233#1:271\n233#1:272,3\n*E\n"})
public final class PubNubUtil {
    @NotNull
    public static final PubNubUtil INSTANCE = new PubNubUtil();
    private static final Logger log = LoggerFactory.getLogger((String)"PubNubUtil");
    @NotNull
    private static final String CHARSET = "UTF-8";
    @NotNull
    public static final String SIGNATURE_QUERY_PARAM_NAME = "signature";
    @NotNull
    public static final String TIMESTAMP_QUERY_PARAM_NAME = "timestamp";
    @NotNull
    public static final String AUTH_QUERY_PARAM_NAME = "auth";

    private PubNubUtil() {
    }

    @NotNull
    public final String replaceLast(@NotNull String string, @NotNull String toReplace, @NotNull String replacement) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        int pos = StringsKt.lastIndexOf$default((CharSequence)string, (String)toReplace, (int)0, (boolean)false, (int)6, null);
        if (pos > -1) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(replacement);
            String string4 = string.substring(pos + toReplace.length(), string.length());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string2 = stringBuilder2.append(string4).toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    @Nullable
    public final String urlDecode(@Nullable String stringToEncode) {
        String string;
        try {
            string = URLDecoder.decode(stringToEncode, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Request signRequest(@NotNull Request originalRequest, @NotNull BasePNConfiguration pnConfiguration, int timestamp) {
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkNotNullParameter((Object)pnConfiguration, (String)"pnConfiguration");
        if (!BasePNConfiguration.Companion.isValid(pnConfiguration.getSecretKey())) {
            return originalRequest;
        }
        String signature = this.generateSignature(originalRequest, timestamp, pnConfiguration.getSubscribeKey(), pnConfiguration.getPublishKey(), pnConfiguration.getSecretKey());
        HttpUrl rebuiltUrl = originalRequest.url().newBuilder().addQueryParameter(TIMESTAMP_QUERY_PARAM_NAME, String.valueOf(timestamp)).addQueryParameter(SIGNATURE_QUERY_PARAM_NAME, signature).build();
        return originalRequest.newBuilder().url(rebuiltUrl).build();
    }

    public final boolean shouldSignRequest(@NotNull BasePNConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return BasePNConfiguration.Companion.isValid(configuration.getSecretKey());
    }

    @NotNull
    public final String generateSignature(@NotNull String requestURL, @NotNull Map<String, String> queryParams, @NotNull String method, @Nullable String requestBody, int timestamp, @NotNull String subscribeKey, @NotNull String publishKey, @NotNull String secretKey) {
        boolean isV2Signature;
        Intrinsics.checkNotNullParameter((Object)requestURL, (String)"requestURL");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)subscribeKey, (String)"subscribeKey");
        Intrinsics.checkNotNullParameter((Object)publishKey, (String)"publishKey");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        StringBuilder signatureBuilder = new StringBuilder();
        queryParams.put(TIMESTAMP_QUERY_PARAM_NAME, String.valueOf(timestamp));
        boolean classic = true;
        String encodedQueryString = this.preparePamArguments$pubnub_core_impl(queryParams);
        boolean bl = isV2Signature = !StringsKt.startsWith$default((String)requestURL, (String)"/publish", (boolean)false, (int)2, null) || !StringsKt.equals((String)method, (String)"post", (boolean)true);
        if (!isV2Signature) {
            signatureBuilder.append(subscribeKey).append("\n");
            signatureBuilder.append(publishKey).append("\n");
            signatureBuilder.append(requestURL).append("\n");
            signatureBuilder.append(encodedQueryString);
        } else {
            String string = method;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            signatureBuilder.append(string2).append("\n");
            signatureBuilder.append(publishKey).append("\n");
            signatureBuilder.append(requestURL).append("\n");
            signatureBuilder.append(encodedQueryString).append("\n");
            signatureBuilder.append(requestBody);
        }
        String signature = "";
        try {
            String string = signatureBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signatureBuilder.toString()");
            signature = this.signSHA256$pubnub_core_impl(secretKey, string);
            if (isV2Signature) {
                signature = this.removeTrailingEqualSigns(signature);
                signature = "v2." + signature;
            }
        }
        catch (PubNubException e) {
            log.warn("signature failed on SignatureInterceptor: " + (Object)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            log.warn("signature failed on SignatureInterceptor: " + e);
        }
        return signature;
    }

    @NotNull
    public final String signSHA256$pubnub_core_impl(@NotNull String key, @NotNull String data) {
        Mac mac;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Mac sha256HMAC = null;
        byte[] hmacData = null;
        Charset charset = Charset.forName(CHARSET);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = key.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        SecretKeySpec secretKey = new SecretKeySpec(byArray, "HmacSHA256");
        try {
            Mac mac2 = Mac.getInstance("HmacSHA256");
            Intrinsics.checkNotNullExpressionValue((Object)mac2, (String)"{\n                Mac.ge\u2026macSHA256\")\n            }");
            mac = mac2;
        }
        catch (NoSuchAlgorithmException e) {
            PubNubException pubNubException = Crypto.newCryptoError(0, e);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)pubNubException), (String)"newCryptoError(0, e)");
            throw (Throwable)pubNubException;
        }
        sha256HMAC = mac;
        try {
            sha256HMAC.init(secretKey);
        }
        catch (InvalidKeyException e) {
            PubNubException pubNubException = Crypto.newCryptoError(0, e);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)pubNubException), (String)"newCryptoError(0, e)");
            throw (Throwable)pubNubException;
        }
        Charset charset2 = Charset.forName(CHARSET);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charsetName)");
        byte[] byArray2 = data.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = sha256HMAC.doFinal(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"sha256HMAC.doFinal(data.\u2026eArray(charset(CHARSET)))");
        hmacData = byArray3;
        byte[] byArray4 = Base64.encode(hmacData, 2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"encode(hmacData, com.pub\u2026al.vendor.Base64.NO_WRAP)");
        byte[] byArray5 = byArray4;
        Charset charset3 = Charset.forName(CHARSET);
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(CHARSET)");
        Charset charset4 = charset3;
        String signed = StringsKt.replace$default((String)StringsKt.replace$default((String)new String(byArray5, charset4), (char)'+', (char)'-', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null);
        return signed;
    }

    private final String generateSignature(Request request, int timestamp, String subscribeKey, String publishKey, String secretKey) {
        Map queryParams = new LinkedHashMap();
        for (String queryKey : request.url().queryParameterNames()) {
            String value = request.url().queryParameter(queryKey);
            if (value == null) continue;
            queryParams.put(queryKey, value);
        }
        return this.generateSignature(request.url().encodedPath(), queryParams, request.method(), this.requestBodyToString$pubnub_core_impl(request), timestamp, subscribeKey, publishKey, secretKey);
    }

    @NotNull
    public final String removeTrailingEqualSigns(@NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)SIGNATURE_QUERY_PARAM_NAME);
        String cleanSignature = signature;
        while (cleanSignature.charAt(cleanSignature.length() - 1) == '=') {
            Intrinsics.checkNotNullExpressionValue((Object)cleanSignature.substring(0, cleanSignature.length() - 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return cleanSignature;
    }

    @Nullable
    public final String requestBodyToString$pubnub_core_impl(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() == null) {
            return "";
        }
        try {
            Buffer buffer = new Buffer();
            RequestBody requestBody = request.body();
            Intrinsics.checkNotNull((Object)requestBody);
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @NotNull
    public final String preparePamArguments$pubnub_core_impl(@NotNull Map<String, String> pamArgs) {
        Intrinsics.checkNotNullParameter(pamArgs, (String)"pamArgs");
        Set pamKeys = new TreeSet(pamArgs.keySet());
        String stringifiedArguments = "";
        int i = 0;
        for (String pamKey : pamKeys) {
            if (i != 0) {
                stringifiedArguments = stringifiedArguments + '&';
            }
            StringBuilder stringBuilder = new StringBuilder().append(stringifiedArguments).append(pamKey).append('=');
            String string = pamArgs.get(pamKey);
            Intrinsics.checkNotNull((Object)string);
            stringifiedArguments = stringBuilder.append(PubNubUtil.pamEncode$pubnub_core_impl$default(this, string, false, 2, null)).toString();
            ++i;
        }
        return stringifiedArguments;
    }

    /*
     * WARNING - void declaration
     */
    private final String preparePamArguments(String encodedQueryString) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"&"};
        Iterable $this$map$iv = CollectionsKt.toSortedSet((Iterable)StringsKt.split$default((CharSequence)encodedQueryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(INSTANCE.pamEncode$pubnub_core_impl((String)it, true));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String pamEncode$pubnub_core_impl(@NotNull String stringToEncode, boolean alreadyPercentEncoded) {
        String string;
        Intrinsics.checkNotNullParameter((Object)stringToEncode, (String)"stringToEncode");
        if (alreadyPercentEncoded) {
            string = stringToEncode;
        } else {
            String string2 = URLEncoder.encode(stringToEncode, CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(stringToEncode, \"UTF-8\")");
            string = StringsKt.replace$default((String)string2, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        }
        String $this$pamEncode_u24lambda_u241 = string;
        boolean bl = false;
        return StringsKt.replace$default((String)$this$pamEncode_u24lambda_u241, (String)"*", (String)"%2A", (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String pamEncode$pubnub_core_impl$default(PubNubUtil pubNubUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return pubNubUtil.pamEncode$pubnub_core_impl(string, bl);
    }

    public final void maybeAddEeQueryParam$pubnub_core_impl(@NotNull Map<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        queryParams.put("ee", "");
    }
}

