/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.utils.AggregateTranslator;
import com.prowidesoftware.swift.utils.JavaUnicodeEscaper;
import com.prowidesoftware.swift.utils.LookupTranslator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConstraintUtils {
    private static final Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_ESCAPE;

    public static String escapeEcmaScript(String input) {
        if (input == null) {
            return null;
        }
        HashMap<String, String> escapeEcmaScriptMap = new HashMap<String, String>();
        escapeEcmaScriptMap.put("'", "\\'");
        escapeEcmaScriptMap.put("\"", "\\\"");
        escapeEcmaScriptMap.put("\\", "\\\\");
        escapeEcmaScriptMap.put("/", "\\/");
        AggregateTranslator translator = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(escapeEcmaScriptMap)), new LookupTranslator(JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
        return translator.translate(input);
    }

    static {
        HashMap<String, String> initialMap = new HashMap<String, String>();
        initialMap.put("\b", "\\b");
        initialMap.put("\n", "\\n");
        initialMap.put("\t", "\\t");
        initialMap.put("\f", "\\f");
        initialMap.put("\r", "\\r");
        JAVA_CTRL_CHARS_ESCAPE = Collections.unmodifiableMap(initialMap);
    }
}

