/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field140;
import com.prowidesoftware.swift.model.field.Field142;
import com.prowidesoftware.swift.model.field.Field143;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT024
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT024.class.getName());
    public static final String NAME = "024";

    public MT024(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT024(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT024 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT024(m);
    }

    public MT024() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT024(String sender, String receiver) {
        super(24, sender, receiver);
    }

    public MT024(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT024.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT024 object from FIN content with a Service Message. Check if the MT024 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT024 object from FIN content with message type " + param.getType());
        }
    }

    public static MT024 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT024(fin);
    }

    public MT024(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT024 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT024(stream);
    }

    public MT024(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT024 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT024(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT024 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT024 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT024 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT024 fromJson(String json) {
        return (MT024)AbstractMT.fromJson(json);
    }

    public Field140 getField140() {
        Tag t = this.tag("140");
        if (t != null) {
            return new Field140(t.getValue());
        }
        return null;
    }

    public Field142 getField142() {
        Tag t = this.tag("142");
        if (t != null) {
            return new Field142(t.getValue());
        }
        return null;
    }

    public Field143 getField143() {
        Tag t = this.tag("143");
        if (t != null) {
            return new Field143(t.getValue());
        }
        return null;
    }
}

