/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field23G
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "23G";
    public static final String F_23G = "23G";
    public static final Integer FUNCTION = 1;
    public static final Integer SUBFUNCTION = 2;

    public Field23G() {
        super(2);
    }

    public Field23G(String value) {
        super(value);
    }

    public Field23G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"23G")) {
            throw new IllegalArgumentException("cannot create field 23G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field23G newInstance(Field23G source) {
        Field23G cp = new Field23G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("23G", value);
    }

    public static Tag emptyTag() {
        return new Tag("23G", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 23G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S[/S]";
    }

    @Override
    public String validatorPattern() {
        return "4!c[/4!c]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Function");
        result.add("Subfunction");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "function");
        result.put(2, "subfunction");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("function", 1);
        this.labelMap.put("subfunction", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getFunction() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getSubfunction() {
        return this.getComponent2();
    }

    public Field23G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field23G setFunction(String component1) {
        return this.setComponent1(component1);
    }

    public Field23G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field23G setSubfunction(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "23G";
    }

    public static Field23G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("23G");
        if (t == null) {
            return null;
        }
        return new Field23G(t);
    }

    public static Field23G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field23G.get(msg.getBlock4());
    }

    public static List<Field23G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field23G.getAll(msg.getBlock4());
    }

    public static List<Field23G> getAll(SwiftTagListBlock block) {
        ArrayList<Field23G> result = new ArrayList<Field23G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("23G");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field23G(f));
            }
        }
        return result;
    }

    public static Field23G fromJson(String json) {
        Field23G field = new Field23G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("function") != null) {
            field.setComponent1(jsonObject.get("function").getAsString());
        }
        if (jsonObject.get("subfunction") != null) {
            field.setComponent2(jsonObject.get("subfunction").getAsString());
        }
        return field;
    }
}

