/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class LineWrapper {
    private LineWrapper() {
    }

    public static String wrap(CharSequence _str, int _width, CharSequence _newLineSeq) {
        List<String> wrapped = LineWrapper.wrapIntoList(_str, _width);
        if (wrapped.isEmpty()) {
            return null;
        }
        CharSequence newLineSeq = _newLineSeq != null ? _newLineSeq : System.lineSeparator();
        return String.join(newLineSeq, wrapped);
    }

    public static List<String> wrapIntoList(CharSequence _str, int _width) {
        if (_str == null) {
            return Collections.emptyList();
        }
        int width = Math.max(1, _width);
        int wrapChar = 32;
        String str = LineWrapper.lstripChar(_str, ' ');
        if (str.length() <= width) {
            return Collections.singletonList(str);
        }
        int strLen = str.length();
        ArrayList<String> wrapped = new ArrayList<String>(strLen / _width + 2);
        int offset = 0;
        int idxSpace = -1;
        int idxSpaceWrap = -1;
        while (offset < strLen) {
            String subStr = str.substring(offset, Math.min(offset + width + 1, strLen));
            idxSpace = subStr.indexOf(32);
            if (idxSpace > -1) {
                if (idxSpace == 0) {
                    ++offset;
                    continue;
                }
                idxSpaceWrap = idxSpace + offset;
            }
            if (strLen - offset <= width) break;
            while ((idxSpace = subStr.indexOf(32, idxSpace + 1)) > -1) {
                idxSpaceWrap = idxSpace + offset;
            }
            if (idxSpaceWrap >= offset) {
                wrapped.add(str.substring(offset, idxSpaceWrap));
                offset = idxSpaceWrap + 1;
                continue;
            }
            wrapped.add(str.substring(offset, width + offset));
            offset += width;
        }
        wrapped.add(str.substring(offset, strLen));
        return Collections.unmodifiableList(wrapped);
    }

    public static List<String> wrapIntoListStrict(CharSequence _str, int _width) {
        int wrapChar = 32;
        String leftStrippedString = LineWrapper.lstripChar(_str, ' ');
        if (leftStrippedString == null) {
            return Collections.emptyList();
        }
        int width = Math.max(1, _width);
        if (leftStrippedString.length() <= width) {
            return Collections.singletonList(leftStrippedString);
        }
        int strLen = leftStrippedString.length();
        ArrayList<String> wrapped = new ArrayList<String>(strLen / _width + 2);
        while (StringUtils.isNotBlank((CharSequence)leftStrippedString) && leftStrippedString.length() > width) {
            String subStr = leftStrippedString.substring(0, width);
            wrapped.add(subStr);
            leftStrippedString = leftStrippedString.substring(width);
        }
        if (StringUtils.isNotBlank((CharSequence)leftStrippedString)) {
            wrapped.add(leftStrippedString);
        }
        return Collections.unmodifiableList(wrapped);
    }

    private static String lstripChar(CharSequence _str, char _c) {
        int i;
        if (_str == null) {
            return null;
        }
        for (i = 0; i < _str.length() && _c == _str.charAt(i); ++i) {
        }
        return _str.toString().substring(i);
    }
}

