/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field71D;
import com.prowidesoftware.swift.model.field.Field72Z;
import com.prowidesoftware.swift.model.field.Field79Z;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT730
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT730.class.getName());
    public static final String NAME = "730";

    public MT730(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT730(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT730 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT730(m);
    }

    public MT730() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT730(String sender, String receiver) {
        super(730, sender, receiver);
    }

    public MT730(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT730.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT730 object from FIN content with a Service Message. Check if the MT730 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT730 object from FIN content with message type " + param.getType());
        }
    }

    public static MT730 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT730(fin);
    }

    public MT730(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT730 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT730(stream);
    }

    public MT730(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT730 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT730(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT730 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT730 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT730 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT730 fromJson(String json) {
        return (MT730)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field32D getField32D() {
        Tag t = this.tag("32D");
        if (t != null) {
            return new Field32D(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field71D getField71D() {
        Tag t = this.tag("71D");
        if (t != null) {
            return new Field71D(t.getValue());
        }
        return null;
    }

    public Field72Z getField72Z() {
        Tag t = this.tag("72Z");
        if (t != null) {
            return new Field72Z(t.getValue());
        }
        return null;
    }

    public Field79Z getField79Z() {
        Tag t = this.tag("79Z");
        if (t != null) {
            return new Field79Z(t.getValue());
        }
        return null;
    }
}

