/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import org.apache.commons.lang3.StringUtils;

public class PartyIdentifierUtils {
    public static String getPartyIdentifier(Field field, int cdComponent, int accountComponent) {
        Object accountPart;
        String cd = StringUtils.trimToNull((String)field.getComponent(cdComponent));
        String account = StringUtils.trimToNull((String)field.getComponent(accountComponent));
        String cdPart = cd != null ? "/" + cd : null;
        Object object = accountPart = account != null ? "/" + account : null;
        if (cdPart != null && accountPart == null) {
            accountPart = "/";
        }
        return StringUtils.trimToNull((String)((String)(cdPart != null ? cdPart : "") + (String)(accountPart != null ? accountPart : "")));
    }

    public static Field setPartyIdentifier(Field field, int cdComponent, int accountComponent, String partyIdentifier) {
        if ((partyIdentifier = StringUtils.trimToNull((String)partyIdentifier)) == null || !partyIdentifier.startsWith("/")) {
            field.setComponent(cdComponent, null);
            field.setComponent(accountComponent, null);
            return field;
        }
        String dcMark = SwiftParseUtils.getTokenFirst(partyIdentifier, "/", "/");
        if (StringUtils.isNotEmpty((CharSequence)dcMark)) {
            field.setComponent(cdComponent, dcMark);
            field.setComponent(accountComponent, SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)partyIdentifier, (int)1), "/"));
        } else {
            field.setComponent(cdComponent, null);
            field.setComponent(accountComponent, StringUtils.substring((String)partyIdentifier, (int)1));
        }
        return field;
    }
}

