/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92N
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92N";
    public static final String F_92N = "92N";
    public static final Integer QUALIFIER = 1;
    public static final Integer QUANTITY = 2;
    public static final Integer CURRENCY_CODE = 3;
    public static final Integer AMOUNT = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92N() {
        super(4);
    }

    public Field92N(String value) {
        super(value);
    }

    public Field92N(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92N")) {
            throw new IllegalArgumentException("cannot create field 92N from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92N newInstance(Field92N source) {
        Field92N cp = new Field92N();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92N", value);
    }

    public static Tag emptyTag() {
        return new Tag("92N", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getAlphaPrefixTrimSlash(SwiftParseUtils.getTokenSecondLast(toparse, "/")));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(SwiftParseUtils.getTokenSecondLast(toparse, "/")));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        BigDecimal n;
        NumberFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92N");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent4AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SICI";
    }

    @Override
    public String parserPattern() {
        return ":S//N/SN";
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<AMOUNT>15/<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Quantity");
        result.add("Currency Code");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "quantity");
        result.put(3, "currencyCode");
        result.put(4, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("quantity", 2);
        this.labelMap.put("currencycode", 3);
        this.labelMap.put("currency", 3);
        this.labelMap.put("amount", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    public String getQuantity() {
        return this.getComponent2();
    }

    public BigDecimal getQuantityAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrencyCode() {
        return this.getComponent3();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent3AsCurrency();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent4();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    public Field92N setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92N setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field92N setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92N setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field92N setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field92N setQuantity(String component2) {
        return this.setComponent2(component2);
    }

    public Field92N setQuantity(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field92N setQuantity(Number component2) {
        return this.setComponent2(component2);
    }

    public Field92N setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92N setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field92N setCurrencyCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field92N setCurrencyCode(Currency component3) {
        return this.setComponent3(component3);
    }

    public Field92N setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92N setComponent4(BigDecimal component4) {
        this.setComponent(4, SwiftFormatUtils.getBigDecimal(component4));
        return this;
    }

    public Field92N setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field92N setAmount(String component4) {
        return this.setComponent4(component4);
    }

    public Field92N setAmount(BigDecimal component4) {
        return this.setComponent4(component4);
    }

    public Field92N setAmount(Number component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92N";
    }

    public static Field92N get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92N");
        if (t == null) {
            return null;
        }
        return new Field92N(t);
    }

    public static Field92N get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92N.get(msg.getBlock4());
    }

    public static List<Field92N> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92N.getAll(msg.getBlock4());
    }

    public static List<Field92N> getAll(SwiftTagListBlock block) {
        ArrayList<Field92N> result = new ArrayList<Field92N>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("92N");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field92N(f));
            }
        }
        return result;
    }

    public static Field92N fromJson(String json) {
        Field92N field = new Field92N();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("quantity") != null) {
            field.setComponent2(jsonObject.get("quantity").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent3(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent4(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

