/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field90B
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90B";
    public static final String F_90B = "90B";
    public static final Integer QUALIFIER = 1;
    public static final Integer AMOUNT_TYPE_CODE = 2;
    public static final Integer CURRENCY_CODE = 3;
    public static final Integer PRICE = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90B() {
        super(4);
    }

    public Field90B(String value) {
        super(value);
    }

    public Field90B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"90B")) {
            throw new IllegalArgumentException("cannot create field 90B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field90B newInstance(Field90B source) {
        Field90B cp = new Field90B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("90B", value);
    }

    public static Tag emptyTag() {
        return new Tag("90B", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getAlphaPrefixTrimSlash(SwiftParseUtils.getTokenSecondLast(toparse, "/")));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(SwiftParseUtils.getTokenSecondLast(toparse, "/")));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent4AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SSCI";
    }

    @Override
    public String parserPattern() {
        return ":S//S/SN";
    }

    @Override
    public String validatorPattern() {
        return ":4!c//4!c/<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Amount Type Code");
        result.add("Currency Code");
        result.add("Price");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "amountTypeCode");
        result.put(3, "currencyCode");
        result.put(4, "price");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("amounttypecode", 2);
        this.labelMap.put("currencycode", 3);
        this.labelMap.put("currency", 3);
        this.labelMap.put("price", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAmountTypeCode() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrencyCode() {
        return this.getComponent3();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent3AsCurrency();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    public String getPrice() {
        return this.getComponent4();
    }

    public BigDecimal getPriceAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    public Field90B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90B setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field90B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90B setAmountTypeCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field90B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90B setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field90B setCurrencyCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field90B setCurrencyCode(Currency component3) {
        return this.setComponent3(component3);
    }

    public Field90B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90B setComponent4(BigDecimal component4) {
        this.setComponent(4, SwiftFormatUtils.getBigDecimal(component4));
        return this;
    }

    public Field90B setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field90B setPrice(String component4) {
        return this.setComponent4(component4);
    }

    public Field90B setPrice(BigDecimal component4) {
        return this.setComponent4(component4);
    }

    public Field90B setPrice(Number component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "90B";
    }

    public static Field90B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90B");
        if (t == null) {
            return null;
        }
        return new Field90B(t);
    }

    public static Field90B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90B.get(msg.getBlock4());
    }

    public static List<Field90B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90B.getAll(msg.getBlock4());
    }

    public static List<Field90B> getAll(SwiftTagListBlock block) {
        ArrayList<Field90B> result = new ArrayList<Field90B>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("90B");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field90B(f));
            }
        }
        return result;
    }

    public static Field90B fromJson(String json) {
        Field90B field = new Field90B();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("amountTypeCode") != null) {
            field.setComponent2(jsonObject.get("amountTypeCode").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent3(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("price") != null) {
            field.setComponent4(jsonObject.get("price").getAsString());
        }
        return field;
    }
}

