/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field27
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "27";
    public static final String F_27 = "27";
    public static final Integer NUMBER = 1;
    public static final Integer MESSAGE_NUMBER = 1;
    public static final Integer TOTAL = 2;
    public static final Integer SEQUENCE_NUMBER = 2;

    public Field27() {
        super(2);
    }

    public Field27(String value) {
        super(value);
    }

    public Field27(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"27")) {
            throw new IllegalArgumentException("cannot create field 27 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field27 newInstance(Field27 source) {
        Field27 cp = new Field27();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("27", value);
    }

    public static Tag emptyTag() {
        return new Tag("27", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 27");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "NN";
    }

    @Override
    public String parserPattern() {
        return "S/S";
    }

    @Override
    public String validatorPattern() {
        return "1n/1n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number");
        result.add("Total");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "number");
        result.put(2, "total");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("number", 1);
        this.labelMap.put("messagenumber", 1);
        this.labelMap.put("total", 2);
        this.labelMap.put("sequencenumber", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getNumber() {
        return this.getComponent1();
    }

    public String getMessageNumber() {
        return this.getNumber();
    }

    public Long getNumberAsLong() {
        return this.getComponent1AsLong();
    }

    public Long getMessageNumberAsLong() {
        return this.getNumberAsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getTotal() {
        return this.getComponent2();
    }

    public String getSequenceNumber() {
        return this.getTotal();
    }

    public Long getTotalAsLong() {
        return this.getComponent2AsLong();
    }

    public Long getSequenceNumberAsLong() {
        return this.getTotalAsLong();
    }

    public Field27 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field27 setComponent1(Long component1) {
        this.setComponent(1, SwiftFormatUtils.getLong(component1));
        return this;
    }

    public Field27 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field27 setNumber(String component1) {
        return this.setComponent1(component1);
    }

    public Field27 setNumber(Long component1) {
        return this.setComponent1(component1);
    }

    public Field27 setNumber(Number component1) {
        return this.setComponent1(component1);
    }

    public Field27 setMessageNumber(String component1) {
        return this.setNumber(component1);
    }

    public Field27 setMessageNumber(Long component1) {
        return this.setNumber(component1);
    }

    public Field27 setMessageNumber(Number component1) {
        return this.setNumber(component1);
    }

    public Field27 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field27 setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field27 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field27 setTotal(String component2) {
        return this.setComponent2(component2);
    }

    public Field27 setTotal(Long component2) {
        return this.setComponent2(component2);
    }

    public Field27 setTotal(Number component2) {
        return this.setComponent2(component2);
    }

    public Field27 setSequenceNumber(String component2) {
        return this.setTotal(component2);
    }

    public Field27 setSequenceNumber(Long component2) {
        return this.setTotal(component2);
    }

    public Field27 setSequenceNumber(Number component2) {
        return this.setTotal(component2);
    }

    @Override
    public String getName() {
        return "27";
    }

    public static Field27 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("27");
        if (t == null) {
            return null;
        }
        return new Field27(t);
    }

    public static Field27 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field27.get(msg.getBlock4());
    }

    public static List<Field27> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field27.getAll(msg.getBlock4());
    }

    public static List<Field27> getAll(SwiftTagListBlock block) {
        ArrayList<Field27> result = new ArrayList<Field27>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("27");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field27(f));
            }
        }
        return result;
    }

    public static Field27 fromJson(String json) {
        Field27 field = new Field27();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("messageNumber") != null) {
            field.setComponent1(jsonObject.get("messageNumber").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent1(jsonObject.get("number").getAsString());
        }
        if (jsonObject.get("sequenceNumber") != null) {
            field.setComponent2(jsonObject.get("sequenceNumber").getAsString());
        }
        if (jsonObject.get("total") != null) {
            field.setComponent2(jsonObject.get("total").getAsString());
        }
        return field;
    }
}

