/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field172
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "172";
    public static final String F_172 = "172";
    public static final Integer START_DATE = 1;
    public static final Integer END_DATE = 2;

    public Field172() {
        super(2);
    }

    public Field172(String value) {
        super(value);
    }

    public Field172(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"172")) {
            throw new IllegalArgumentException("cannot create field 172 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field172 newInstance(Field172 source) {
        Field172 cp = new Field172();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("172", value);
    }

    public static Tag emptyTag() {
        return new Tag("172", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            if (value.length() >= 4) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)4));
            }
            if (value.length() > 4) {
                this.setComponent2(StringUtils.substring((String)value, (int)4));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        SimpleDateFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 172");
        }
        if (component == 1) {
            f = new SimpleDateFormat("MMM dd", this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("MMM dd", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "JJ";
    }

    @Override
    public String parserPattern() {
        return "<DATE1><DATE1>";
    }

    @Override
    public String validatorPattern() {
        return "<DATE1><DATE1>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Start Date");
        result.add("End Date");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "startDate");
        result.put(2, "endDate");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("startdate", 1);
        this.labelMap.put("enddate", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getMonthDay(this.getComponent(1));
    }

    public String getStartDate() {
        return this.getComponent1();
    }

    public Calendar getStartDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getMonthDay(this.getComponent(2));
    }

    public String getEndDate() {
        return this.getComponent2();
    }

    public Calendar getEndDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public Field172 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field172 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getMonthDay(component1));
        return this;
    }

    public Field172 setStartDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field172 setStartDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field172 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field172 setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getMonthDay(component2));
        return this;
    }

    public Field172 setEndDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field172 setEndDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "172";
    }

    public static Field172 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("172");
        if (t == null) {
            return null;
        }
        return new Field172(t);
    }

    public static Field172 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field172.get(msg.getBlock4());
    }

    public static List<Field172> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field172.getAll(msg.getBlock4());
    }

    public static List<Field172> getAll(SwiftTagListBlock block) {
        ArrayList<Field172> result = new ArrayList<Field172>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("172");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field172(f));
            }
        }
        return result;
    }

    public static Field172 fromJson(String json) {
        Field172 field = new Field172();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("startDate") != null) {
            field.setComponent1(jsonObject.get("startDate").getAsString());
        }
        if (jsonObject.get("endDate") != null) {
            field.setComponent2(jsonObject.get("endDate").getAsString());
        }
        return field;
    }
}

