/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultilineUtil {
    private static final transient Logger log = Logger.getLogger(MultilineUtil.class.getName());

    public String[] removeInnerEmptyLines(String[] lines) {
        return this.removeInnerEmptyLines(lines, false);
    }

    public String[] removeInnerEmptyLines(String[] lines, boolean keepAll) {
        Objects.requireNonNull(lines, "lines cannot be null");
        if (lines.length == 0) {
            return lines;
        }
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<String> empty = null;
        if (keepAll) {
            empty = new ArrayList<String>();
        }
        for (String line : lines) {
            if (this.isEmpty(line)) {
                if (!keepAll) continue;
                empty.add(line);
                continue;
            }
            text.add(line);
        }
        if (keepAll) {
            text.addAll(empty);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("text: " + text);
        }
        return text.toArray(new String[0]);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

