/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractWriter {
    protected Writer writer;

    public AbstractWriter(Writer writer) {
        this.writer = writer;
    }

    public AbstractWriter(File file) throws FileNotFoundException {
        this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public AbstractWriter(String filename) throws FileNotFoundException {
        this(new File(filename));
    }

    public AbstractWriter(File _file, Charset _charset) throws FileNotFoundException {
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(_file), _charset != null ? _charset : StandardCharsets.UTF_8));
    }

    public AbstractWriter(OutputStream stream) {
        this.writer = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
    }

    public AbstractWriter(OutputStream _stream, Charset _charset) {
        this.writer = new BufferedWriter(new OutputStreamWriter(_stream, _charset != null ? _charset : StandardCharsets.UTF_8));
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }
}

