/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field45A;
import com.prowidesoftware.swift.model.field.Field46A;
import com.prowidesoftware.swift.model.field.Field47A;
import com.prowidesoftware.swift.model.field.Field49G;
import com.prowidesoftware.swift.model.field.Field49H;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT721
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT721.class.getName());
    public static final String NAME = "721";

    public MT721(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT721(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT721 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT721(m);
    }

    public MT721() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT721(String sender, String receiver) {
        super(721, sender, receiver);
    }

    public MT721(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT721.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT721 object from FIN content with a Service Message. Check if the MT721 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT721 object from FIN content with message type " + param.getType());
        }
    }

    public static MT721 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT721(fin);
    }

    public MT721(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT721 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT721(stream);
    }

    public MT721(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT721 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT721(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT721 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT721 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT721 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT721 fromJson(String json) {
        return (MT721)AbstractMT.fromJson(json);
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field45A getField45A() {
        Tag t = this.tag("45A");
        if (t != null) {
            return new Field45A(t.getValue());
        }
        return null;
    }

    public Field46A getField46A() {
        Tag t = this.tag("46A");
        if (t != null) {
            return new Field46A(t.getValue());
        }
        return null;
    }

    public Field47A getField47A() {
        Tag t = this.tag("47A");
        if (t != null) {
            return new Field47A(t.getValue());
        }
        return null;
    }

    public Field49G getField49G() {
        Tag t = this.tag("49G");
        if (t != null) {
            return new Field49G(t.getValue());
        }
        return null;
    }

    public Field49H getField49H() {
        Tag t = this.tag("49H");
        if (t != null) {
            return new Field49H(t.getValue());
        }
        return null;
    }
}

