/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field128;
import com.prowidesoftware.swift.model.field.Field129;
import com.prowidesoftware.swift.model.field.Field130;
import com.prowidesoftware.swift.model.field.Field132;
import com.prowidesoftware.swift.model.field.Field133;
import com.prowidesoftware.swift.model.field.Field134;
import com.prowidesoftware.swift.model.field.Field304;
import com.prowidesoftware.swift.model.field.Field307;
import com.prowidesoftware.swift.model.field.Field312;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT074
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT074.class.getName());
    public static final String NAME = "074";

    public MT074(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT074(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT074 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT074(m);
    }

    public MT074() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT074(String sender, String receiver) {
        super(74, sender, receiver);
    }

    public MT074(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT074.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT074 object from FIN content with a Service Message. Check if the MT074 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT074 object from FIN content with message type " + param.getType());
        }
    }

    public static MT074 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT074(fin);
    }

    public MT074(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT074 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT074(stream);
    }

    public MT074(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT074 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT074(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT074 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT074 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT074 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT074 fromJson(String json) {
        return (MT074)AbstractMT.fromJson(json);
    }

    public Field128 getField128() {
        Tag t = this.tag("128");
        if (t != null) {
            return new Field128(t.getValue());
        }
        return null;
    }

    public Field307 getField307() {
        Tag t = this.tag("307");
        if (t != null) {
            return new Field307(t.getValue());
        }
        return null;
    }

    public Field129 getField129() {
        Tag t = this.tag("129");
        if (t != null) {
            return new Field129(t.getValue());
        }
        return null;
    }

    public Field130 getField130() {
        Tag t = this.tag("130");
        if (t != null) {
            return new Field130(t.getValue());
        }
        return null;
    }

    public Field134 getField134() {
        Tag t = this.tag("134");
        if (t != null) {
            return new Field134(t.getValue());
        }
        return null;
    }

    public Field312 getField312() {
        Tag t = this.tag("312");
        if (t != null) {
            return new Field312(t.getValue());
        }
        return null;
    }

    public List<Field304> getField304() {
        ArrayList<Field304> result = new ArrayList<Field304>();
        Tag[] tags = this.tags("304");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field304(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field132> getField132() {
        ArrayList<Field132> result = new ArrayList<Field132>();
        Tag[] tags = this.tags("132");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field132(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field133> getField133() {
        ArrayList<Field133> result = new ArrayList<Field133>();
        Tag[] tags = this.tags("133");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field133(tag.getValue()));
            }
        }
        return result;
    }
}

