/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.OptionGPartyField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Field50G
extends OptionGPartyField
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50G";
    public static final String F_50G = "50G";

    public Field50G() {
    }

    public Field50G(String value) {
        super(value);
    }

    public Field50G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"50G")) {
            throw new IllegalArgumentException("cannot create field 50G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field50G newInstance(Field50G source) {
        Field50G cp = new Field50G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("50G", value);
    }

    public static Tag emptyTag() {
        return new Tag("50G", "");
    }

    @Override
    public final String validatorPattern() {
        return "/34x$<BIC>";
    }

    public Field50G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field50G setAccount(String component1) {
        return this.setComponent1(component1);
    }

    public Field50G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50G setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field50G setIdentifierCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field50G setIdentifierCode(BIC component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field50G setBIC(String component2) {
        return this.setIdentifierCode(component2);
    }

    @Deprecated
    public Field50G setBIC(BIC component2) {
        return this.setIdentifierCode(component2);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getName() {
        return "50G";
    }

    public static Field50G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("50G");
        if (t == null) {
            return null;
        }
        return new Field50G(t);
    }

    public static Field50G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field50G.get(msg.getBlock4());
    }

    public static List<Field50G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field50G.getAll(msg.getBlock4());
    }

    public static List<Field50G> getAll(SwiftTagListBlock block) {
        ArrayList<Field50G> result = new ArrayList<Field50G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("50G");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field50G(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field50G cp = Field50G.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field50G cp = Field50G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field50G cp = Field50G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field50G fromJson(String json) {
        Field50G field = new Field50G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("account") != null) {
            field.setComponent1(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent2(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent2(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

