/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field28
extends Field
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "28";
    public static final String F_28 = "28";
    @Deprecated
    public static final String PARSER_PATTERN = "S[/S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "NN";
    @Deprecated
    public static final String TYPES_PATTERN = "NN";
    public static final Integer STATEMENT_NUMBER = 1;
    public static final Integer SETTLEMENT_NUMBER = 1;
    public static final Integer SEQUENCE_NUMBER = 2;
    public static final Integer PAGE_NUMBER = 2;

    public Field28() {
        super(2);
    }

    public Field28(String value) {
        super(value);
    }

    public Field28(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"28")) {
            throw new IllegalArgumentException("cannot create field 28 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field28 newInstance(Field28 source) {
        Field28 cp = new Field28();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("28", value);
    }

    public static Tag emptyTag() {
        return new Tag("28", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 28");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "NN";
    }

    @Override
    public String typesPattern() {
        return "NN";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "5n[/2n]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Statement Number");
        result.add("Sequence Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "statementNumber");
        result.put(2, "sequenceNumber");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("statementnumber", 1);
        this.labelMap.put("settlementnumber", 1);
        this.labelMap.put("sequencenumber", 2);
        this.labelMap.put("pagenumber", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    @Deprecated
    public Number getComponent1AsNumber() {
        Long l = this.getComponent1AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getStatementNumber() {
        return this.getComponent1();
    }

    public String getSettlementNumber() {
        return this.getStatementNumber();
    }

    public Long getStatementNumberAsLong() {
        return this.getComponent1AsLong();
    }

    @Deprecated
    public Number getStatementNumberAsNumber() {
        return this.getComponent1AsNumber();
    }

    public Long getSettlementNumberAsLong() {
        return this.getStatementNumberAsLong();
    }

    @Deprecated
    public Number getSettlementNumberAsNumber() {
        return this.getStatementNumberAsNumber();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        Long l = this.getComponent2AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getSequenceNumber() {
        return this.getComponent2();
    }

    public String getPageNumber() {
        return this.getSequenceNumber();
    }

    public Long getSequenceNumberAsLong() {
        return this.getComponent2AsLong();
    }

    @Deprecated
    public Number getSequenceNumberAsNumber() {
        return this.getComponent2AsNumber();
    }

    public Long getPageNumberAsLong() {
        return this.getSequenceNumberAsLong();
    }

    @Deprecated
    public Number getPageNumberAsNumber() {
        return this.getSequenceNumberAsNumber();
    }

    public Field28 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field28 setComponent1(Long component1) {
        this.setComponent(1, SwiftFormatUtils.getLong(component1));
        return this;
    }

    public Field28 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field28 setStatementNumber(String component1) {
        return this.setComponent1(component1);
    }

    public Field28 setStatementNumber(Long component1) {
        return this.setComponent1(component1);
    }

    public Field28 setStatementNumber(Number component1) {
        return this.setComponent1(component1);
    }

    public Field28 setSettlementNumber(String component1) {
        return this.setStatementNumber(component1);
    }

    public Field28 setSettlementNumber(Long component1) {
        return this.setStatementNumber(component1);
    }

    public Field28 setSettlementNumber(Number component1) {
        return this.setStatementNumber(component1);
    }

    public Field28 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field28 setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field28 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field28 setSequenceNumber(String component2) {
        return this.setComponent2(component2);
    }

    public Field28 setSequenceNumber(Long component2) {
        return this.setComponent2(component2);
    }

    public Field28 setSequenceNumber(Number component2) {
        return this.setComponent2(component2);
    }

    public Field28 setPageNumber(String component2) {
        return this.setSequenceNumber(component2);
    }

    public Field28 setPageNumber(Long component2) {
        return this.setSequenceNumber(component2);
    }

    public Field28 setPageNumber(Number component2) {
        return this.setSequenceNumber(component2);
    }

    @Override
    public String getName() {
        return "28";
    }

    public static Field28 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("28");
        if (t == null) {
            return null;
        }
        return new Field28(t);
    }

    public static Field28 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field28.get(msg.getBlock4());
    }

    public static List<Field28> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field28.getAll(msg.getBlock4());
    }

    public static List<Field28> getAll(SwiftTagListBlock block) {
        ArrayList<Field28> result = new ArrayList<Field28>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("28");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field28(f));
            }
        }
        return result;
    }

    public static Field28 fromJson(String json) {
        Field28 field = new Field28();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("settlementNumber") != null) {
            field.setComponent1(jsonObject.get("settlementNumber").getAsString());
        }
        if (jsonObject.get("statementNumber") != null) {
            field.setComponent1(jsonObject.get("statementNumber").getAsString());
        }
        if (jsonObject.get("pageNumber") != null) {
            field.setComponent2(jsonObject.get("pageNumber").getAsString());
        }
        if (jsonObject.get("sequenceNumber") != null) {
            field.setComponent2(jsonObject.get("sequenceNumber").getAsString());
        }
        return field;
    }
}

