/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.StringReader;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;

public class NamespaceReader {
    private static final Logger log = Logger.getLogger(NamespaceReader.class.getName());

    public static Optional<String> findDocumentNamespace(String xml) {
        return NamespaceReader.findNamespaceForLocalName(xml, "Document");
    }

    public static Optional<String> findAppHdrNamespace(String xml) {
        return NamespaceReader.findNamespaceForLocalName(xml, "AppHdr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> findNamespaceForLocalName(String xml, String localName) {
        XMLInputFactory xif = SafeXmlUtils.inputFactory();
        XMLStreamReader reader = null;
        try {
            reader = xif.createXMLStreamReader(new StringReader(MxParseUtils.makeXmlLenient(xml)));
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event || !reader.getLocalName().equals(localName)) continue;
                Optional<String> optional = Optional.ofNullable(NamespaceReader.readNamespace(reader));
                return optional;
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Error parsing XML to find namespace in " + localName, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    log.log(Level.WARNING, "Error closing XMLStreamReader", e);
                }
            }
        }
        return Optional.empty();
    }

    private static String readNamespace(XMLStreamReader reader) {
        if (reader.getNamespaceCount() > 0) {
            for (int nsIndex = 0; nsIndex < reader.getNamespaceCount(); ++nsIndex) {
                String elementPrefix;
                String nsPrefix = StringUtils.trimToNull((String)reader.getNamespacePrefix(nsIndex));
                if (!StringUtils.equals((CharSequence)nsPrefix, (CharSequence)(elementPrefix = StringUtils.trimToNull((String)reader.getPrefix())))) continue;
                return reader.getNamespaceURI(nsIndex);
            }
        }
        return null;
    }

    @Deprecated
    public static boolean elementExists(String xml, String localName) {
        DeprecationUtils.phase2(NamespaceReader.class, (String)"elementExists", (String)"Use MxParseUtils.elementExists(String, String) instead");
        return MxParseUtils.elementExists(xml, localName);
    }
}

