/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMXAdapter;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrAdapter;
import com.prowidesoftware.swift.model.mx.EnvelopeType;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.MxReadConfiguration;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import com.prowidesoftware.swift.model.mx.MxWriteConfiguration;
import com.prowidesoftware.swift.model.mx.MxWriteImpl;
import com.prowidesoftware.swift.model.mx.MxWriteParams;
import com.prowidesoftware.swift.model.mx.adapters.LocalDateJsonAdapter;
import com.prowidesoftware.swift.model.mx.adapters.OffsetDateTimeJsonAdapter;
import com.prowidesoftware.swift.model.mx.adapters.OffsetTimeJsonAdapter;
import com.prowidesoftware.swift.model.mx.adapters.YearJsonAdapter;
import com.prowidesoftware.swift.model.mx.adapters.YearMonthJsonAdapter;
import com.prowidesoftware.swift.model.mx.adapters.v9.V9DateTimeJsonAdapter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public abstract class AbstractMX
extends AbstractMessage
implements JsonSerializable {
    public static final String DOCUMENT_LOCALNAME = "Document";
    private static final Logger log = Logger.getLogger(AbstractMX.class.getName());
    @Deprecated
    public static String DEFAULT_ROOT_ELEMENT = "RequestPayload";
    private AppHdr appHdr;

    protected AbstractMX() {
        super(MessageStandardType.MX);
    }

    protected AbstractMX(AppHdr appHdr) {
        super(MessageStandardType.MX);
        this.appHdr = appHdr;
    }

    public static AbstractMX parse(String xml) {
        return MxReadImpl.parse(xml, null, new MxReadParams());
    }

    public static AbstractMX parse(String xml, MxId id) {
        return MxReadImpl.parse(xml, id, new MxReadParams());
    }

    public static AbstractMX parse(Element e) {
        String prefix = e.getPrefix();
        if (prefix != null) {
            NamedNodeMap attributes = e.getAttributes();
            ArrayList<Node> removables = new ArrayList<Node>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if (StringUtils.equals((CharSequence)attr.getNodeName(), (CharSequence)("xmlns:" + prefix)) || StringUtils.equals((CharSequence)attr.getNodeName(), (CharSequence)"xmlns:xsi")) continue;
                removables.add(attr);
            }
            for (Node attr : removables) {
                attributes.removeNamedItem(attr.getNodeName());
            }
        }
        DOMImplementationLS lsImpl = (DOMImplementationLS)e.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String xml = serializer.writeToString(e);
        if (e.getNamespaceURI() != null) {
            return AbstractMX.parse(xml, new MxId(e.getNamespaceURI()), new MxReadConfiguration());
        }
        return null;
    }

    public static AbstractMX parse(String xml, MxId id, MxReadConfiguration conf) {
        return MxReadImpl.parse(xml, id, new MxReadParams(conf));
    }

    protected static <T> T fromJson(String json, Class<T> classOfT) {
        Gson gson = AbstractMX.getGsonBuilderWithV10Adapters();
        return (T)gson.fromJson(json, classOfT);
    }

    public static AbstractMX fromJson(String json) {
        Gson gson = AbstractMX.getGsonBuilderWithV10Adapters();
        return (AbstractMX)((Object)gson.fromJson(json, AbstractMX.class));
    }

    protected static <T> T fromJsonV9(String json, Class<T> classOfT) {
        Gson gson = AbstractMX.getGsonBuilderWithV9Adapters();
        return (T)gson.fromJson(json, classOfT);
    }

    public static AbstractMX fromJsonV9(String json) {
        Gson gson = AbstractMX.getGsonBuilderWithV9Adapters();
        return (AbstractMX)((Object)gson.fromJson(json, AbstractMX.class));
    }

    public String message(MxWriteConfiguration conf) {
        MxWriteConfiguration usableConf = conf != null ? conf : new MxWriteConfiguration();
        MxWriteParams params = new MxWriteParams(usableConf);
        params.includeXMLDeclaration = false;
        EnvelopeType envelopeType = usableConf.envelopeType;
        String envelopeElement = envelopeType == EnvelopeType.CUSTOM ? usableConf.rootElement : envelopeType.rootElement();
        StringBuilder xml = new StringBuilder();
        if (usableConf.includeXMLDeclaration) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        }
        params.prefix = usableConf.headerPrefix;
        String header = this.header(params);
        if (header != null) {
            xml.append("<");
            if (envelopeType.prefix() != null) {
                xml.append(envelopeType.prefix()).append(":");
            }
            xml.append(envelopeElement);
            if (envelopeType != EnvelopeType.CUSTOM) {
                xml.append(" xmlns=\"").append(usableConf.envelopeType.namespace()).append("\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            }
            xml.append(">\n");
            if (envelopeType.name().startsWith("BME")) {
                xml.append("<").append(envelopeType.prefix()).append(":Hdr>\n");
            }
            xml.append(header).append("\n");
            if (envelopeType.name().startsWith("BME")) {
                xml.append("</").append(envelopeType.prefix()).append(":Hdr>\n");
            }
        }
        if (envelopeType.name().startsWith("BME")) {
            xml.append("<").append(envelopeType.prefix()).append(":Doc>\n");
        }
        params.prefix = usableConf.documentPrefix != null && usableConf.useCategoryAsDocumentPrefix ? this.getBusinessProcess() : usableConf.documentPrefix;
        xml.append(this.document(params)).append("\n");
        if (envelopeType.name().startsWith("BME")) {
            xml.append("</").append(envelopeType.prefix()).append(":Doc>\n");
        }
        if (header != null) {
            xml.append("</");
            if (envelopeType.prefix() != null) {
                xml.append(envelopeType.prefix()).append(":");
            }
            xml.append(envelopeElement).append(">");
        }
        return xml.toString();
    }

    public String header(MxWriteParams params) {
        if (this.appHdr != null) {
            return this.appHdr.xml(params);
        }
        return null;
    }

    public String document(MxWriteParams params) {
        Objects.requireNonNull(params, "marshalling params cannot be null");
        return MxWriteImpl.write(this.getNamespace(), this, this.getClasses(), params);
    }

    public abstract Class[] getClasses();

    public abstract String getNamespace();

    public String header() {
        return this.header(new MxWriteParams());
    }

    public String document() {
        MxWriteConfiguration conf = new MxWriteConfiguration();
        MxWriteParams params = new MxWriteParams(conf);
        params.prefix = conf.documentPrefix;
        return this.document(params);
    }

    public Source xmlSource() {
        String xml = this.message();
        log.fine("XML: " + xml);
        if (xml != null) {
            return new StreamSource(new StringReader(xml));
        }
        return null;
    }

    public String message() {
        return this.message(new MxWriteConfiguration());
    }

    @XmlTransient
    public AppHdr getAppHdr() {
        return this.appHdr;
    }

    public void setAppHdr(AppHdr appHdr) {
        this.appHdr = appHdr;
    }

    public MxId getMxId() {
        MxId mxId = new MxId(this.getBusinessProcess(), StringUtils.leftPad((String)Integer.toString(this.getFunctionality()), (int)3, (String)"0"), StringUtils.leftPad((String)Integer.toString(this.getVariant()), (int)3, (String)"0"), StringUtils.leftPad((String)Integer.toString(this.getVersion()), (int)2, (String)"0"));
        if (this.appHdr != null) {
            mxId.setBusinessService(this.appHdr.serviceName());
        }
        return mxId;
    }

    public abstract String getBusinessProcess();

    public abstract int getFunctionality();

    public abstract int getVariant();

    public abstract int getVersion();

    public Element element() {
        return this.element(null);
    }

    public Element element(JAXBContext inputContext) {
        try {
            JAXBContext context = inputContext != null ? inputContext : JaxbContextLoader.INSTANCE.get(((Object)((Object)this)).getClass(), this.getClasses());
            DOMResult res = new DOMResult();
            context.createMarshaller().marshal((Object)this, (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error creating XML Document for MX", e);
            return null;
        }
    }

    public String toJson() {
        Gson gson = AbstractMX.getGsonBuilderWithV10Adapters();
        return gson.toJson((Object)this, AbstractMX.class);
    }

    public String toJsonV9() {
        Gson gson = AbstractMX.getGsonBuilderWithV9Adapters();
        return gson.toJson((Object)this, AbstractMX.class);
    }

    private static GsonBuilder getGsonBuilderWithCustomAdapters() {
        return new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(OffsetTime.class, (Object)new OffsetTimeJsonAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateJsonAdapter()).registerTypeAdapter(Year.class, (Object)new YearJsonAdapter()).registerTypeAdapter(YearMonth.class, (Object)new YearMonthJsonAdapter()).registerTypeAdapter(AppHdr.class, (Object)new AppHdrAdapter());
    }

    private static Gson getGsonBuilderWithV9Adapters() {
        Gson gson = AbstractMX.getGsonBuilderWithCustomAdapters().registerTypeAdapter(OffsetDateTime.class, (Object)new V9DateTimeJsonAdapter()).setPrettyPrinting().create();
        return gson;
    }

    private static Gson getGsonBuilderWithV10Adapters() {
        Gson gson = AbstractMX.getGsonBuilderWithCustomAdapters().registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeJsonAdapter()).setPrettyPrinting().create();
        return gson;
    }

    public String targetNamespace() {
        return this.getNamespace();
    }
}

