/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SupplementaryDataUtils {
    public static List<String> extract(String sourceXml) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            DocumentBuilder builder = SafeXmlUtils.documentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(sourceXml)));
            NodeList splmtryDataList = SupplementaryDataUtils.extractSplmtryData(document.getDocumentElement());
            for (int i = 0; i < splmtryDataList.getLength(); ++i) {
                Node splmtryData = splmtryDataList.item(i);
                String splmtryDataXml = SupplementaryDataUtils.nodeToString(splmtryData);
                result.add(splmtryDataXml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static NodeList extractSplmtryData(Element element) {
        NodeList splmtryDataList = element.getElementsByTagName("SplmtryData");
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node childNode = element.getChildNodes().item(i);
            if (!(childNode instanceof Element)) continue;
            NodeList childSplmtryDataList = SupplementaryDataUtils.extractSplmtryData((Element)childNode);
            SupplementaryDataUtils.appendNodeList(splmtryDataList, childSplmtryDataList);
        }
        return splmtryDataList;
    }

    private static void appendNodeList(NodeList destination, NodeList source) {
        for (int i = 0; i < source.getLength(); ++i) {
            destination.item(0).getParentNode().appendChild(source.item(i));
        }
    }

    private static String nodeToString(Node node) throws Exception {
        Transformer transformer = SafeXmlUtils.transformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }
}

