/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OffsetDateTimeAdapter
extends XmlAdapter<String, OffsetDateTime> {
    private static final Logger log = Logger.getLogger(OffsetDateTimeAdapter.class.getName());
    private final DateTimeFormatter marshalFormat;
    private final DateTimeFormatter unmarshalFormat;
    private final XmlAdapter<String, OffsetDateTime> customAdapterImpl;
    private final String regex = "\\\\.0{1,}[Z+-]";
    private final Pattern pattern = Pattern.compile("\\\\.0{1,}[Z+-]");
    int minPrecision = 0;
    int maxPrecision = 9;

    public OffsetDateTimeAdapter() {
        this.unmarshalFormat = this.marshalFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, this.minPrecision, this.maxPrecision, true).optionalEnd().optionalStart().appendPattern("XXX").optionalEnd().toFormatter();
        this.customAdapterImpl = null;
    }

    public OffsetDateTimeAdapter(DateTimeFormatter dateFormat) {
        this.marshalFormat = dateFormat;
        this.unmarshalFormat = dateFormat;
        this.customAdapterImpl = null;
    }

    public OffsetDateTimeAdapter(XmlAdapter<String, OffsetDateTime> customAdapterImpl) {
        this.marshalFormat = null;
        this.unmarshalFormat = null;
        this.customAdapterImpl = customAdapterImpl;
    }

    public OffsetDateTime unmarshal(String value) throws Exception {
        if (this.customAdapterImpl != null) {
            return (OffsetDateTime)this.customAdapterImpl.unmarshal((Object)value);
        }
        return OffsetDateTimeAdapter.parseZonedDateTime(this.unmarshalFormat, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal(OffsetDateTime offsetDateTime) throws Exception {
        String formatted;
        if (this.customAdapterImpl != null) {
            return (String)this.customAdapterImpl.marshal((Object)offsetDateTime);
        }
        DateTimeFormatter dateTimeFormatter = this.marshalFormat;
        synchronized (dateTimeFormatter) {
            formatted = OffsetDateTimeAdapter.formatZonedDateTime(this.marshalFormat, offsetDateTime);
        }
        Matcher matcher = this.pattern.matcher(formatted);
        if (matcher.find()) {
            formatted = formatted.replace(matcher.group(), "");
        }
        return formatted.replace("Z", "+00:00");
    }

    static OffsetDateTime parseZonedDateTime(DateTimeFormatter dateTimeFormatter, String value) {
        if (value == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(value, dateTimeFormatter);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Error parsing to OffsetDateTime: " + e.getMessage());
            }
            ZoneId zoneId = ZoneOffset.systemDefault();
            OffsetDateTime dateTime = LocalDateTime.parse(value, dateTimeFormatter).atZone(zoneId).toOffsetDateTime();
            return dateTime;
        }
    }

    static String formatZonedDateTime(DateTimeFormatter dateTimeFormatter, OffsetDateTime offsetDateTime) {
        return dateTimeFormatter.format(offsetDateTime);
    }

    public String toString() {
        return "OffsetDateTimeAdapter{ yyyy-MM-dd'T'HH:mm:ss[.[SSS][SS][S]][XXX] }";
    }
}

