/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.MessageMetadataStrategy;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DefaultMxMetadataStrategy
implements MessageMetadataStrategy {
    private static final transient Logger log = Logger.getLogger(DefaultMxMetadataStrategy.class.getName());

    public Optional<String> reference(AbstractMessage message) {
        if (message.isMX()) {
            MxNode reference;
            MxNode groupHeader;
            String reference2;
            AbstractMX mx = (AbstractMX)message;
            if (mx.getAppHdr() != null && StringUtils.isNotBlank((CharSequence)(reference2 = mx.getAppHdr().reference()))) {
                return Optional.of(reference2);
            }
            MxNode document = MxNode.parse(mx.document());
            MxNode mxNode = groupHeader = document != null ? document.findFirstByName("GrpHdr") : null;
            if (groupHeader != null && (reference = groupHeader.findFirst("./MsgId")) != null && StringUtils.isNotBlank((CharSequence)reference.getValue())) {
                return Optional.of(reference.getValue());
            }
        }
        return Optional.empty();
    }

    public Optional<Money> amount(AbstractMessage message) {
        Money money = null;
        if (message.isMX()) {
            AbstractMX mx = (AbstractMX)message;
            MxNode document = MxNode.parse(mx.document());
            if (this.isPacs004(mx)) {
                money = this.getPacs004Amount(document);
            } else if (this.isPacs(mx)) {
                money = this.getPacsAmount(document);
            } else if (this.isCamt(mx)) {
                if (mx.getFunctionality() == 29) {
                    money = this.getCamt29Amount(document);
                } else if (mx.getFunctionality() == 52) {
                    money = this.getCamt52Amount(document);
                } else if (mx.getFunctionality() == 53) {
                    money = this.getCamt53Amount(document);
                } else if (mx.getFunctionality() == 54) {
                    money = this.getCamt54Amount(document);
                } else if (mx.getFunctionality() == 56) {
                    money = this.getCamt56Amount(document);
                } else if (mx.getFunctionality() == 57) {
                    money = this.getCamt57Amount(document);
                }
            }
        }
        return Optional.ofNullable(money);
    }

    private Money getCamt29Amount(MxNode document) {
        MxNode amount = document.findFirst("./RsltnOfInvstgtn/CxlDtls/OrgnlPmtInfAndSts/TxInfAndSts/OrgnlInstdAmt");
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getCamt52Amount(MxNode document) {
        MxNode amount = document.findFirst("./BkToCstmrAcctRpt/Rpt/Bal/Amt");
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getCamt53Amount(MxNode document) {
        MxNode amount = document.findFirst("./BkToCstmrStmt/Stmt/Bal/Amt");
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getCamt54Amount(MxNode document) {
        MxNode amount = document.findFirst("./BkToCstmrDbtCdtNtfctn/Ntfctn/Ntry/Amt");
        if (amount == null) {
            amount = document.findFirst("./BkToCstmrDbtCdtNtfctn/Ntfctn/Ntry/NtryDtls/Amt");
        }
        if (amount == null) {
            amount = document.findFirst("./BkToCstmrDbtCdtNtfctn/Ntfctn/Ntry/NtryDtls/TxDtls/Amt");
        }
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getCamt56Amount(MxNode document) {
        MxNode amount = document.findFirst("./FIToFIPmtCxlReq/Undrlyg/TxInf/OrgnlIntrBkSttlmAmt");
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getCamt57Amount(MxNode document) {
        MxNode amount = document.findFirst("./NtfctnToRcv/Ntfctn/TtlAmt");
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getPacs004Amount(MxNode document) {
        MxNode amount = document.findFirst("./PmtRtr/GrpHdr/TtlRtrdIntrBkSttlmAmt");
        if (amount == null) {
            amount = document.findFirst("./PmtRtr/TxInf/RtrdIntrBkSttlmAmt");
        }
        if (amount != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private Money getPacsAmount(MxNode document) {
        MxNode amount;
        MxNode amount2;
        MxNode grpHdrNode = document.findFirstByName("GrpHdr");
        if (grpHdrNode != null && (amount2 = grpHdrNode.findFirst("./TtlIntrBkSttlmAmt")) != null && amount2.getValue() != null) {
            return new Money(amount2.getAttribute("Ccy"), new BigDecimal(amount2.getValue()));
        }
        MxNode cdtTrfNode = document.findFirstByName("CdtTrfTxInf");
        if (cdtTrfNode != null && (amount = cdtTrfNode.findFirst("./IntrBkSttlmAmt")) != null) {
            return new Money(amount.getAttribute("Ccy"), new BigDecimal(amount.getValue()));
        }
        return null;
    }

    private boolean isPacs004(AbstractMX mx) {
        return StringUtils.equals((CharSequence)mx.getBusinessProcess(), (CharSequence)"pacs") && mx.getFunctionality() == 4;
    }

    private boolean isPacs(AbstractMX mx) {
        return StringUtils.equals((CharSequence)mx.getBusinessProcess(), (CharSequence)"pacs");
    }

    private boolean isCamt(AbstractMX mx) {
        return StringUtils.equals((CharSequence)mx.getBusinessProcess(), (CharSequence)"camt");
    }

    public Optional<Calendar> valueDate(AbstractMessage message) {
        AbstractMX mx;
        MxNode document;
        Calendar valueDate = null;
        if (message.isMX() && (document = MxNode.parse((mx = (AbstractMX)message).document())) != null) {
            if (this.isPacs(mx)) {
                valueDate = this.getPacsValueDate(document);
            } else if (this.isCamt(mx)) {
                if (mx.getFunctionality() == 52) {
                    valueDate = this.getCamt52ValueDate(document);
                } else if (mx.getFunctionality() == 53) {
                    valueDate = this.getCamt53ValueDate(document);
                } else if (mx.getFunctionality() == 54) {
                    valueDate = this.getCamt54ValueDate(document);
                } else if (mx.getFunctionality() == 56) {
                    valueDate = this.getCamt56ValueDate(document);
                } else if (mx.getFunctionality() == 57) {
                    valueDate = this.getCamt57ValueDate(document);
                } else if (mx.getFunctionality() == 60) {
                    valueDate = this.getCamt60ValueDate(document);
                }
            }
        }
        return Optional.ofNullable(valueDate);
    }

    private Calendar getPacsValueDate(MxNode document) {
        MxNode date = document.findFirstByName("IntrBkSttlmDt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    private Calendar getCalendar(MxNode date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date parsedDate = sdf.parse(date.getValue());
            Calendar cal = Calendar.getInstance();
            cal.setTime(parsedDate);
            return cal;
        }
        catch (ParseException e) {
            log.fine("Error parsing MX date: " + e.getMessage());
            return null;
        }
    }

    private Calendar getCamt52ValueDate(MxNode document) {
        MxNode date = document.findFirst("./BkToCstmrAcctRpt/Rpt/Bal/Dt/Dt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    private Calendar getCamt53ValueDate(MxNode document) {
        MxNode date = document.findFirst("./BkToCstmrStmt/Stmt/Bal/Dt/Dt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    private Calendar getCamt54ValueDate(MxNode document) {
        MxNode date = document.findFirst("./BkToCstmrDbtCdtNtfctn/Ntfctn/Ntry/NtryDtls/TxDtls/RltdDts/IntrBkSttlmDt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    private Calendar getCamt56ValueDate(MxNode document) {
        MxNode date = document.findFirst("./FIToFIPmtCxlReq/Undrlyg/TxInf/OrgnlIntrBkSttlmDt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    private Calendar getCamt57ValueDate(MxNode document) {
        MxNode date = document.findFirst("./NtfctnToRcv/Ntfctn/XpctdValDt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    private Calendar getCamt60ValueDate(MxNode document) {
        MxNode date = document.findFirst("./FIToFIPmtCxlReq/Undrlyg/TxInf/OrgnlIntrBkSttlmDt");
        if (date != null) {
            return this.getCalendar(date);
        }
        return null;
    }

    public Optional<Calendar> tradeDate(AbstractMessage message) {
        return Optional.empty();
    }
}

