
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Describes a financing relation between two parties, for example invoice, credit, financing request, cash accounts.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FinancingAgreementItem1", propOrder = {
    "itmCntxt",
    "itmActn",
    "pmtInstrm",
    "vldtnStsInf",
    "ratg",
    "reopIndctn",
    "grnt",
    "grntSts",
    "rltdGrntLttr",
    "assoctdDoc",
    "addtlInf"
})
public class FinancingAgreementItem1Tsin01100101 {

    @XmlElement(name = "ItmCntxt", required = true)
    protected FinancialItemParameters1Tsin01100101 itmCntxt;
    @XmlElement(name = "ItmActn")
    @XmlSchemaType(name = "string")
    protected AgreementItemAction1Code itmActn;
    @XmlElement(name = "PmtInstrm")
    @XmlSchemaType(name = "string")
    protected PaymentInstrumentCode pmtInstrm;
    @XmlElement(name = "VldtnStsInf")
    protected ValidationStatusInformation1 vldtnStsInf;
    @XmlElement(name = "Ratg")
    protected boolean ratg;
    @XmlElement(name = "ReopIndctn")
    protected boolean reopIndctn;
    @XmlElement(name = "Grnt")
    protected List<GuaranteeDetails1Tsin01100101> grnt;
    @XmlElement(name = "GrntSts")
    protected ValidationStatusInformation1 grntSts;
    @XmlElement(name = "RltdGrntLttr")
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    protected Object rltdGrntLttr;
    @XmlElementRef(name = "AssoctdDoc", namespace = "urn:iso:std:iso:20022:tech:xsd:tsin.011.001.01", type = JAXBElement.class, required = false)
    protected List<JAXBElement<Object>> assoctdDoc;
    @XmlElement(name = "AddtlInf")
    protected List<String> addtlInf;

    /**
     * Gets the value of the itmCntxt property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialItemParameters1Tsin01100101 }
     *     
     */
    public FinancialItemParameters1Tsin01100101 getItmCntxt() {
        return itmCntxt;
    }

    /**
     * Sets the value of the itmCntxt property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialItemParameters1Tsin01100101 }
     *     
     */
    public FinancingAgreementItem1Tsin01100101 setItmCntxt(FinancialItemParameters1Tsin01100101 value) {
        this.itmCntxt = value;
        return this;
    }

    /**
     * Gets the value of the itmActn property.
     * 
     * @return
     *     possible object is
     *     {@link AgreementItemAction1Code }
     *     
     */
    public AgreementItemAction1Code getItmActn() {
        return itmActn;
    }

    /**
     * Sets the value of the itmActn property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgreementItemAction1Code }
     *     
     */
    public FinancingAgreementItem1Tsin01100101 setItmActn(AgreementItemAction1Code value) {
        this.itmActn = value;
        return this;
    }

    /**
     * Gets the value of the pmtInstrm property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentInstrumentCode }
     *     
     */
    public PaymentInstrumentCode getPmtInstrm() {
        return pmtInstrm;
    }

    /**
     * Sets the value of the pmtInstrm property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentInstrumentCode }
     *     
     */
    public FinancingAgreementItem1Tsin01100101 setPmtInstrm(PaymentInstrumentCode value) {
        this.pmtInstrm = value;
        return this;
    }

    /**
     * Gets the value of the vldtnStsInf property.
     * 
     * @return
     *     possible object is
     *     {@link ValidationStatusInformation1 }
     *     
     */
    public ValidationStatusInformation1 getVldtnStsInf() {
        return vldtnStsInf;
    }

    /**
     * Sets the value of the vldtnStsInf property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValidationStatusInformation1 }
     *     
     */
    public FinancingAgreementItem1Tsin01100101 setVldtnStsInf(ValidationStatusInformation1 value) {
        this.vldtnStsInf = value;
        return this;
    }

    /**
     * Gets the value of the ratg property.
     * 
     */
    public boolean isRatg() {
        return ratg;
    }

    /**
     * Sets the value of the ratg property.
     * 
     */
    public FinancingAgreementItem1Tsin01100101 setRatg(boolean value) {
        this.ratg = value;
        return this;
    }

    /**
     * Gets the value of the reopIndctn property.
     * 
     */
    public boolean isReopIndctn() {
        return reopIndctn;
    }

    /**
     * Sets the value of the reopIndctn property.
     * 
     */
    public FinancingAgreementItem1Tsin01100101 setReopIndctn(boolean value) {
        this.reopIndctn = value;
        return this;
    }

    /**
     * Gets the value of the grnt property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the grnt property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrnt().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GuaranteeDetails1Tsin01100101 }
     * 
     * 
     * @return
     *     The value of the grnt property.
     */
    public List<GuaranteeDetails1Tsin01100101> getGrnt() {
        if (grnt == null) {
            grnt = new ArrayList<>();
        }
        return this.grnt;
    }

    /**
     * Gets the value of the grntSts property.
     * 
     * @return
     *     possible object is
     *     {@link ValidationStatusInformation1 }
     *     
     */
    public ValidationStatusInformation1 getGrntSts() {
        return grntSts;
    }

    /**
     * Sets the value of the grntSts property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValidationStatusInformation1 }
     *     
     */
    public FinancingAgreementItem1Tsin01100101 setGrntSts(ValidationStatusInformation1 value) {
        this.grntSts = value;
        return this;
    }

    /**
     * Gets the value of the rltdGrntLttr property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getRltdGrntLttr() {
        return rltdGrntLttr;
    }

    /**
     * Sets the value of the rltdGrntLttr property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public FinancingAgreementItem1Tsin01100101 setRltdGrntLttr(Object value) {
        this.rltdGrntLttr = value;
        return this;
    }

    /**
     * Gets the value of the assoctdDoc property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the assoctdDoc property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssoctdDoc().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link Object }{@code >}
     * 
     * 
     * @return
     *     The value of the assoctdDoc property.
     */
    public List<JAXBElement<Object>> getAssoctdDoc() {
        if (assoctdDoc == null) {
            assoctdDoc = new ArrayList<>();
        }
        return this.assoctdDoc;
    }

    /**
     * Gets the value of the addtlInf property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the addtlInf property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddtlInf().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the addtlInf property.
     */
    public List<String> getAddtlInf() {
        if (addtlInf == null) {
            addtlInf = new ArrayList<>();
        }
        return this.addtlInf;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the grnt list.
     * @see #getGrnt()
     * 
     */
    public FinancingAgreementItem1Tsin01100101 addGrnt(GuaranteeDetails1Tsin01100101 grnt) {
        getGrnt().add(grnt);
        return this;
    }

    /**
     * Adds a new item to the assoctdDoc list.
     * @see #getAssoctdDoc()
     * 
     */
    public FinancingAgreementItem1Tsin01100101 addAssoctdDoc(JAXBElement<Object> assoctdDoc) {
        getAssoctdDoc().add(assoctdDoc);
        return this;
    }

    /**
     * Adds a new item to the addtlInf list.
     * @see #getAddtlInf()
     * 
     */
    public FinancingAgreementItem1Tsin01100101 addAddtlInf(String addtlInf) {
        getAddtlInf().add(addtlInf);
        return this;
    }

}
