/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OffsetDateTimeJsonAdapter
implements JsonSerializer<OffsetDateTime>,
JsonDeserializer<OffsetDateTime> {
    private static final Logger log = Logger.getLogger(OffsetDateTimeJsonAdapter.class.getName());
    private final Gson gson = new Gson();

    public JsonElement serialize(OffsetDateTime offsetDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
        DateTimeOffsetDTO dateTimeOffsetDTO = new DateTimeOffsetDTO();
        dateTimeOffsetDTO.dateTime.date.year = offsetDateTime.getYear();
        dateTimeOffsetDTO.dateTime.date.month = offsetDateTime.getMonthValue();
        dateTimeOffsetDTO.dateTime.date.day = offsetDateTime.getDayOfMonth();
        dateTimeOffsetDTO.dateTime.time.hour = offsetDateTime.getHour();
        dateTimeOffsetDTO.dateTime.time.minute = offsetDateTime.getMinute();
        dateTimeOffsetDTO.dateTime.time.second = offsetDateTime.getSecond();
        dateTimeOffsetDTO.dateTime.time.nano = offsetDateTime.getNano();
        if (offsetDateTime.getOffset() != null) {
            dateTimeOffsetDTO.offset = new OffsetDTO();
            dateTimeOffsetDTO.offset.totalSeconds = offsetDateTime.getOffset().getTotalSeconds();
        }
        return this.gson.toJsonTree((Object)dateTimeOffsetDTO, DateTimeOffsetDTO.class);
    }

    public OffsetDateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            OffsetDateTime offsetDateTime;
            DateTimeOffsetDTO dateTimeOffsetDTO = (DateTimeOffsetDTO)this.gson.fromJson(jsonElement, DateTimeOffsetDTO.class);
            int nano = 0;
            if (dateTimeOffsetDTO.dateTime.time.nano != null) {
                nano = dateTimeOffsetDTO.dateTime.time.nano;
            }
            if (dateTimeOffsetDTO.offset != null) {
                ZoneOffset zoneoffset = ZoneOffset.ofTotalSeconds(dateTimeOffsetDTO.offset.totalSeconds);
                offsetDateTime = OffsetDateTime.of(dateTimeOffsetDTO.dateTime.date.year, dateTimeOffsetDTO.dateTime.date.month, dateTimeOffsetDTO.dateTime.date.day, dateTimeOffsetDTO.dateTime.time.hour, dateTimeOffsetDTO.dateTime.time.minute, dateTimeOffsetDTO.dateTime.time.second, nano, zoneoffset);
            } else {
                LocalDateTime localDateTime = LocalDateTime.of((int)dateTimeOffsetDTO.dateTime.date.year, dateTimeOffsetDTO.dateTime.date.month, (int)dateTimeOffsetDTO.dateTime.date.day, (int)dateTimeOffsetDTO.dateTime.time.hour, (int)dateTimeOffsetDTO.dateTime.time.minute, (int)dateTimeOffsetDTO.dateTime.time.second, nano);
                ZoneId zoneId = ZoneOffset.systemDefault();
                offsetDateTime = localDateTime.atZone(zoneId).toOffsetDateTime();
            }
            return offsetDateTime;
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot parse JSON into OffsetDateTime: " + e.getMessage(), e);
            return null;
        }
    }

    static class OffsetDTO {
        Integer totalSeconds = 0;

        OffsetDTO() {
        }
    }

    static class TimeDTO {
        Integer hour = 0;
        Integer minute = 0;
        Integer second = 0;
        Integer nano = 0;

        TimeDTO() {
        }
    }

    static class DateDTO {
        Integer year;
        Integer month;
        Integer day;

        DateDTO() {
        }
    }

    static class DateTimeDTO {
        DateDTO date = new DateDTO();
        TimeDTO time = new TimeDTO();

        DateTimeDTO() {
        }
    }

    static class DateTimeOffsetDTO {
        DateTimeDTO dateTime = new DateTimeDTO();
        OffsetDTO offset;

        DateTimeOffsetDTO() {
        }
    }
}

