/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactivefeign.spring.config.EnableReactiveFeignClients;
import reactivefeign.spring.config.ReactiveFeignClient;
import reactivefeign.spring.config.ReactiveFeignClientFactoryBean;
import reactivefeign.spring.config.ReactiveFeignClientSpecification;
import reactivefeign.utils.StringUtils;

class ReactiveFeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerDefaultConfiguration(metadata, registry);
        this.registerReactiveFeignClients(metadata, registry);
    }

    private void registerDefaultConfiguration(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map defaultAttrs = metadata.getAnnotationAttributes(EnableReactiveFeignClients.class.getName(), true);
        if (defaultAttrs != null && defaultAttrs.containsKey("defaultConfiguration")) {
            String name = metadata.hasEnclosingClass() ? "default." + metadata.getEnclosingClassName() : "default." + metadata.getClassName();
            this.registerClientConfiguration(registry, name, defaultAttrs.get("defaultConfiguration"));
        }
    }

    public void registerReactiveFeignClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Set<String> basePackages;
        Class[] clients;
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        Map attrs = metadata.getAnnotationAttributes(EnableReactiveFeignClients.class.getName());
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(ReactiveFeignClient.class);
        Class[] classArray = clients = attrs == null ? null : (Class[])attrs.get("clients");
        if (clients == null || clients.length == 0) {
            scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
            basePackages = this.getBasePackages(metadata);
        } else {
            final HashSet<String> clientClasses = new HashSet<String>();
            basePackages = new HashSet<String>();
            for (Class clazz : clients) {
                basePackages.add(ClassUtils.getPackageName((Class)clazz));
                clientClasses.add(clazz.getCanonicalName());
            }
            AbstractClassTestingTypeFilter filter = new AbstractClassTestingTypeFilter(){

                protected boolean match(ClassMetadata metadata) {
                    String cleaned = metadata.getClassName().replaceAll("\\$", ".");
                    return clientClasses.contains(cleaned);
                }
            };
            scanner.addIncludeFilter((TypeFilter)new AllTypeFilter(Arrays.asList(filter, annotationTypeFilter)));
        }
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@ReactiveFeignClient can only be specified on an interface");
                Map attributes = annotationMetadata.getAnnotationAttributes(ReactiveFeignClient.class.getCanonicalName());
                String name = this.getQualifier(attributes);
                if (!org.springframework.util.StringUtils.hasText((String)name)) {
                    name = this.getClientName(attributes);
                }
                this.registerClientConfiguration(registry, name, attributes.get("configuration"));
                this.registerReactiveFeignClient(registry, annotationMetadata, attributes);
            }
        }
    }

    private void registerReactiveFeignClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(ReactiveFeignClientFactoryBean.class);
        this.validate(attributes);
        definition.addPropertyValue("url", (Object)this.getUrl(attributes));
        definition.addPropertyValue("path", (Object)this.getPath(attributes));
        String name = this.getName(attributes);
        definition.addPropertyValue("name", (Object)name);
        definition.addPropertyValue("type", (Object)className);
        definition.addPropertyValue("decode404", attributes.get("decode404"));
        definition.addPropertyValue("fallback", attributes.get("fallback"));
        definition.addPropertyValue("fallbackFactory", attributes.get("fallbackFactory"));
        definition.setAutowireMode(2);
        Object alias = name + "ReactiveFeignClient";
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)className);
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        String qualifier = this.getQualifier(attributes);
        if (org.springframework.util.StringUtils.hasText((String)qualifier)) {
            alias = qualifier;
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, new String[]{alias});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        ReactiveFeignClientsRegistrar.validateFallback(annotation.getClass("fallback"));
        ReactiveFeignClientsRegistrar.validateFallbackFactory(annotation.getClass("fallbackFactory"));
    }

    static void validateFallback(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback class must implement the interface annotated by @FeignClient");
    }

    static void validateFallbackFactory(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback factory must produce instances of fallback classes that implement the interface annotated by @FeignClient");
    }

    String getName(Map<String, Object> attributes) {
        String name = (String)attributes.get("serviceId");
        if (!org.springframework.util.StringUtils.hasText((String)name)) {
            name = (String)attributes.get("name");
        }
        if (!org.springframework.util.StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        name = this.resolve(name);
        return ReactiveFeignClientsRegistrar.getName(name);
    }

    static String getName(String name) {
        if (!org.springframework.util.StringUtils.hasText((String)name)) {
            return "";
        }
        String host = null;
        try {
            Object url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI((String)url).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assert.state((host != null ? 1 : 0) != 0, (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    private String resolve(String value) {
        if (org.springframework.util.StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    private String getUrl(Map<String, Object> attributes) {
        String url = this.resolve((String)attributes.get("url"));
        return ReactiveFeignClientsRegistrar.getUrl(url);
    }

    static String getUrl(String url) {
        if (!(!org.springframework.util.StringUtils.hasText((String)url) || ((String)url).startsWith("#{") && ((String)url).contains("}"))) {
            if (!((String)url).contains("://")) {
                url = "http://" + (String)url;
            }
            try {
                new URL((String)url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException((String)url + " is malformed", e);
            }
        }
        return url;
    }

    private String getPath(Map<String, Object> attributes) {
        String path = this.resolve((String)attributes.get("path"));
        return ReactiveFeignClientsRegistrar.getPath(path);
    }

    static String getPath(String path) {
        if (org.springframework.util.StringUtils.hasText((String)path)) {
            if (!((String)(path = ((String)path).trim())).startsWith("/")) {
                path = "/" + (String)path;
            }
            path = StringUtils.cutTail((String)path, (String)"/");
        }
        return path;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableReactiveFeignClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!org.springframework.util.StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!org.springframework.util.StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private String getQualifier(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (org.springframework.util.StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    private String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("value");
        if (!org.springframework.util.StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (!org.springframework.util.StringUtils.hasText((String)value)) {
            value = (String)client.get("serviceId");
        }
        if (org.springframework.util.StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + ReactiveFeignClient.class.getSimpleName());
    }

    private void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ReactiveFeignClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + "." + ReactiveFeignClientSpecification.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private static class AllTypeFilter
    implements TypeFilter {
        private final List<TypeFilter> delegates;

        public AllTypeFilter(List<TypeFilter> delegates) {
            Assert.notNull(delegates, (String)"This argument is required, it must not be null");
            this.delegates = delegates;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter filter : this.delegates) {
                if (filter.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }
}

