/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import java.util.function.Consumer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.cloud2.CloudReactiveFeign;
import reactivefeign.cloud2.ReactiveFeignCircuitBreakerFactory;
import reactivefeign.spring.config.AbstractReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignCircuitBreakerCustomizer;
import reactivefeign.spring.config.ReactiveFeignNamedContext;

public class ReactiveFeignCircuitBreakerConfigurator
extends AbstractReactiveFeignConfigurator {
    protected ReactiveFeignCircuitBreakerConfigurator() {
        super(3);
    }

    @Override
    public ReactiveFeignBuilder configure(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext) {
        if (!(builder instanceof CloudReactiveFeign.Builder)) {
            throw new IllegalArgumentException("CloudReactiveFeign.Builder expected");
        }
        CloudReactiveFeign.Builder cloudBuilder = (CloudReactiveFeign.Builder)builder;
        ReactiveFeignCircuitBreakerFactory feignCircuitBreakerFactory = namedContext.getOptional(ReactiveFeignCircuitBreakerFactory.class);
        if (feignCircuitBreakerFactory != null) {
            return cloudBuilder.enableCircuitBreaker(feignCircuitBreakerFactory);
        }
        ReactiveCircuitBreakerFactory circuitBreakerFactory = namedContext.getOptional(ReactiveCircuitBreakerFactory.class);
        if (circuitBreakerFactory != null) {
            Consumer circuitBreakerCustomizer = namedContext.getOptional(ReactiveFeignCircuitBreakerCustomizer.class);
            feignCircuitBreakerFactory = circuitBreakerCustomizer != null ? circuitBreakerId -> {
                circuitBreakerFactory.configure(circuitBreakerCustomizer, new String[]{circuitBreakerId});
                return circuitBreakerFactory.create(circuitBreakerId);
            } : arg_0 -> ((ReactiveCircuitBreakerFactory)circuitBreakerFactory).create(arg_0);
            return cloudBuilder.enableCircuitBreaker(feignCircuitBreakerFactory);
        }
        return builder;
    }
}

