/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud2.methodhandler;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.lang.Nullable;
import reactivefeign.cloud2.ReactiveFeignCircuitBreakerFactory;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.utils.FeignUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CircuitBreakerMethodHandler
implements MethodHandler {
    private final MethodHandler methodHandler;
    private final BiFunction<Throwable, Object[], Object> fallbackFactory;
    private final ReactiveCircuitBreaker reactiveCircuitBreaker;

    CircuitBreakerMethodHandler(Target target, MethodMetadata methodMetadata, MethodHandler methodHandler, ReactiveFeignCircuitBreakerFactory reactiveCircuitBreakerFactory, @Nullable Function<Throwable, Object> fallbackInstanceFactory) {
        Util.checkNotNull((Object)target, (String)"target must be not null", (Object[])new Object[0]);
        Util.checkNotNull((Object)methodMetadata, (String)"methodMetadata must be not null", (Object[])new Object[0]);
        this.methodHandler = (MethodHandler)Util.checkNotNull((Object)methodHandler, (String)"methodHandler must be not null", (Object[])new Object[0]);
        Util.checkNotNull((Object)reactiveCircuitBreakerFactory, (String)"reactiveCircuitBreakerFactory must be not null", (Object[])new Object[0]);
        String circuitBreakerId = methodMetadata.configKey();
        this.reactiveCircuitBreaker = (ReactiveCircuitBreaker)reactiveCircuitBreakerFactory.apply(circuitBreakerId);
        Method method = FeignUtils.findMethodInTarget((Target)target, (MethodMetadata)methodMetadata);
        method.setAccessible(true);
        this.fallbackFactory = this.buildFallbackFactory(fallbackInstanceFactory, method);
    }

    public Publisher<Object> invoke(Object[] argv) throws Throwable {
        Object publisher = this.methodHandler.invoke(argv);
        if (publisher instanceof Mono) {
            if (this.fallbackFactory != null) {
                return this.reactiveCircuitBreaker.run((Mono)publisher, t -> (Mono)this.fallbackFactory.apply((Throwable)t, argv));
            }
            return this.reactiveCircuitBreaker.run((Mono)publisher);
        }
        if (this.fallbackFactory != null) {
            return this.reactiveCircuitBreaker.run((Flux)publisher, t -> (Flux)this.fallbackFactory.apply((Throwable)t, argv));
        }
        return this.reactiveCircuitBreaker.run((Flux)publisher);
    }

    private BiFunction<Throwable, Object[], Object> buildFallbackFactory(Function<Throwable, Object> fallbackInstanceFactory, Method method) {
        if (fallbackInstanceFactory == null) {
            return null;
        }
        return (throwable, argv) -> {
            Object fallbackInstance = fallbackInstanceFactory.apply((Throwable)throwable);
            try {
                return method.invoke(fallbackInstance, argv);
            }
            catch (InvocationTargetException e) {
                throw Exceptions.propagate((Throwable)e.getCause());
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        };
    }
}

