/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingBiFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface ThrowingBiConsumer<T, U, E extends Exception> {
    public void accept(T var1, U var2) throws E;

    default public ThrowingBiConsumer<T, U, E> andThenConsume(ThrowingBiConsumer<? super T, ? super U, ? extends E> after) {
        Objects.requireNonNull(after);
        return (arg1, arg2) -> {
            this.accept(arg1, arg2);
            after.accept(arg1, arg2);
        };
    }

    default public ThrowingBiFunction<T, U, Void, E> asFunction() {
        return (arg1, arg2) -> {
            this.accept(arg1, arg2);
            return null;
        };
    }

    public static <T, U> BiConsumer<T, U> unchecked(ThrowingBiConsumer<T, U, ?> consumer) {
        return Objects.requireNonNull(consumer).uncheck();
    }

    public static <T, U> BiConsumer<T, U> sneaky(ThrowingBiConsumer<T, U, ?> consumer) {
        Objects.requireNonNull(consumer);
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }

    default public BiConsumer<T, U> uncheck() {
        return (arg1, arg2) -> {
            try {
                this.accept(arg1, arg2);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

