/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import com.pivovarit.collectors.AsyncParallelCollector;
import com.pivovarit.collectors.BatchingSpliterator;
import com.pivovarit.collectors.CompletionStrategy;
import com.pivovarit.collectors.Dispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ParallelStreamCollector<T, R>
implements Collector<T, List<CompletableFuture<R>>, Stream<R>> {
    private static final EnumSet<Collector.Characteristics> UNORDERED = EnumSet.of(Collector.Characteristics.UNORDERED);
    private final Function<T, R> function;
    private final CompletionStrategy<R> completionStrategy;
    private final Set<Collector.Characteristics> characteristics;
    private final Dispatcher<R> dispatcher;

    private ParallelStreamCollector(Function<T, R> function, CompletionStrategy<R> completionStrategy, Set<Collector.Characteristics> characteristics, Dispatcher<R> dispatcher) {
        this.completionStrategy = completionStrategy;
        this.characteristics = characteristics;
        this.dispatcher = dispatcher;
        this.function = function;
    }

    @Override
    public Supplier<List<CompletableFuture<R>>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<CompletableFuture<R>>, T> accumulator() {
        return (acc, e) -> acc.add(this.dispatcher.enqueue(() -> this.function.apply(e)));
    }

    @Override
    public BinaryOperator<List<CompletableFuture<R>>> combiner() {
        return (left, right) -> {
            throw new UnsupportedOperationException("Using parallel stream with parallel collectors is a bad idea");
        };
    }

    @Override
    public Function<List<CompletableFuture<R>>, Stream<R>> finisher() {
        return this.completionStrategy;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.characteristics;
    }

    static <T, R> Collector<T, ?, Stream<R>> streaming(Function<T, R> mapper) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        return new ParallelStreamCollector<T, R>(mapper, CompletionStrategy.unordered(), UNORDERED, Dispatcher.virtual());
    }

    static <T, R> Collector<T, ?, Stream<R>> streaming(Function<T, R> mapper, Executor executor, int parallelism) {
        Objects.requireNonNull(executor, "executor can't be null");
        Objects.requireNonNull(mapper, "mapper can't be null");
        AsyncParallelCollector.requireValidParallelism(parallelism);
        return new ParallelStreamCollector<T, R>(mapper, CompletionStrategy.unordered(), UNORDERED, Dispatcher.from(executor, parallelism));
    }

    static <T, R> Collector<T, ?, Stream<R>> streamingOrdered(Function<T, R> mapper) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        return new ParallelStreamCollector<T, R>(mapper, CompletionStrategy.ordered(), Collections.emptySet(), Dispatcher.virtual());
    }

    static <T, R> Collector<T, ?, Stream<R>> streamingOrdered(Function<T, R> mapper, Executor executor, int parallelism) {
        Objects.requireNonNull(executor, "executor can't be null");
        Objects.requireNonNull(mapper, "mapper can't be null");
        AsyncParallelCollector.requireValidParallelism(parallelism);
        return new ParallelStreamCollector<T, R>(mapper, CompletionStrategy.ordered(), Collections.emptySet(), Dispatcher.from(executor, parallelism));
    }

    static final class BatchingCollectors {
        private BatchingCollectors() {
        }

        static <T, R> Collector<T, ?, Stream<R>> streaming(Function<T, R> mapper, Executor executor, int parallelism) {
            Objects.requireNonNull(executor, "executor can't be null");
            Objects.requireNonNull(mapper, "mapper can't be null");
            AsyncParallelCollector.requireValidParallelism(parallelism);
            return parallelism == 1 ? BatchingCollectors.syncCollector(mapper) : BatchingCollectors.batchingCollector(mapper, executor, parallelism);
        }

        static <T, R> Collector<T, ?, Stream<R>> streamingOrdered(Function<T, R> mapper, Executor executor, int parallelism) {
            Objects.requireNonNull(executor, "executor can't be null");
            Objects.requireNonNull(mapper, "mapper can't be null");
            AsyncParallelCollector.requireValidParallelism(parallelism);
            return parallelism == 1 ? BatchingCollectors.syncCollector(mapper) : BatchingCollectors.batchingCollector(mapper, executor, parallelism);
        }

        private static <T, R> Collector<T, ?, Stream<R>> batchingCollector(Function<T, R> mapper, Executor executor, int parallelism) {
            return Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == parallelism) {
                    return (Stream)list.stream().collect(new ParallelStreamCollector(mapper, CompletionStrategy.ordered(), Collections.emptySet(), Dispatcher.from(executor, parallelism)));
                }
                return BatchingSpliterator.partitioned(list, parallelism).collect(Collectors.collectingAndThen(new ParallelStreamCollector(BatchingSpliterator.batching(mapper), CompletionStrategy.ordered(), Collections.emptySet(), Dispatcher.from(executor, parallelism)), s -> s.flatMap(Collection::stream)));
            });
        }

        private static <T, R> Collector<T, Stream.Builder<R>, Stream<R>> syncCollector(Function<T, R> mapper) {
            return Collector.of(Stream::builder, (rs, t) -> rs.add(mapper.apply(t)), (rs, rs2) -> {
                throw new UnsupportedOperationException("Using parallel stream with parallel collectors is a bad idea");
            }, Stream.Builder::build, new Collector.Characteristics[0]);
        }
    }
}

