/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

final class Dispatcher<T> {
    private final CompletableFuture<Void> completionSignaller = new CompletableFuture();
    private final Executor executor;
    private final Semaphore limiter;

    private Dispatcher() {
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
        this.limiter = null;
    }

    private Dispatcher(Executor executor, int permits) {
        this.executor = executor;
        this.limiter = new Semaphore(permits);
    }

    static <T> Dispatcher<T> from(Executor executor, int permits) {
        return new Dispatcher<T>(executor, permits);
    }

    static <T> Dispatcher<T> virtual() {
        return new Dispatcher<T>();
    }

    CompletableFuture<T> enqueue(Supplier<T> supplier) {
        InterruptibleCompletableFuture future = new InterruptibleCompletableFuture();
        this.completionSignaller.whenComplete(Dispatcher.shortcircuit(future));
        try {
            this.executor.execute(this.completionTask(supplier, future));
        }
        catch (Throwable e) {
            this.completionSignaller.completeExceptionally(e);
            return CompletableFuture.failedFuture(e);
        }
        return future;
    }

    private FutureTask<T> completionTask(Supplier<T> supplier, InterruptibleCompletableFuture<T> future) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            block7: {
                if (!this.completionSignaller.isCompletedExceptionally()) {
                    try {
                        if (this.limiter == null) {
                            future.complete(supplier.get());
                            break block7;
                        }
                        try {
                            this.limiter.acquire();
                            future.complete(supplier.get());
                        }
                        finally {
                            this.limiter.release();
                        }
                    }
                    catch (Throwable e) {
                        this.completionSignaller.completeExceptionally(e);
                    }
                }
            }
        }, null);
        future.completedBy(task);
        return task;
    }

    private static <T> BiConsumer<T, Throwable> shortcircuit(InterruptibleCompletableFuture<?> future) {
        return (__, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                future.cancel(true);
            }
        };
    }

    static final class InterruptibleCompletableFuture<T>
    extends CompletableFuture<T> {
        private volatile FutureTask<T> backingTask;

        InterruptibleCompletableFuture() {
        }

        private void completedBy(FutureTask<T> task) {
            this.backingTask = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            FutureTask<T> task = this.backingTask;
            if (task != null) {
                task.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

