/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import com.pivovarit.collectors.CompletionOrderSpliterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

sealed interface CompletionStrategy<T>
extends Function<List<CompletableFuture<T>>, Stream<T>> {
    public static final Unordered<?> UNORDERED = new Unordered();
    public static final Ordered<?> ORDERED = new Ordered();

    public static <R> CompletionStrategy<R> unordered() {
        return UNORDERED;
    }

    public static <R> CompletionStrategy<R> ordered() {
        return ORDERED;
    }

    public static final class Unordered<T>
    implements CompletionStrategy<T> {
        @Override
        public Stream<T> apply(List<CompletableFuture<T>> futures) {
            return StreamSupport.stream(new CompletionOrderSpliterator<T>(futures), false);
        }
    }

    public static final class Ordered<T>
    implements CompletionStrategy<T> {
        @Override
        public Stream<T> apply(List<CompletableFuture<T>> futures) {
            return futures.stream().map(CompletableFuture::join);
        }
    }
}

