/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.MoreObjects;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.OpenOp;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.Level;
import java.util.ArrayDeque;
import java.util.List;

public final class DocBuilder {
    private final Level base = Level.make(OpenOp.builder().plusIndent(Indent.Const.ZERO).debugName("root").build());
    private final ArrayDeque<Level> stack = new ArrayDeque();
    private Level appendLevel = this.base;

    public DocBuilder() {
        this.stack.addLast(this.base);
    }

    public DocBuilder withOps(List<Op> ops) {
        for (Op op : ops) {
            op.add(this);
        }
        return this;
    }

    public void open(OpenOp openOp) {
        Level level = Level.make(openOp);
        this.stack.addLast(level);
    }

    public void close() {
        Level top = this.stack.removeLast();
        this.stack.peekLast().add(top);
    }

    void add(Doc doc) {
        this.appendLevel.add(doc);
    }

    void breakDoc(Break breakDoc) {
        this.appendLevel = this.stack.peekLast();
        this.appendLevel.add(breakDoc);
    }

    public Level build() {
        return this.base;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("base", (Object)this.base).add("stack", this.stack).add("appendLevel", (Object)this.appendLevel).toString();
    }
}

