/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.palantir.javaformat.doc.JsonDocVisitor;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.State;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public final class JsonSink
implements Obs.Sink {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module());
    private final Map<Integer, ArrayNode> childrenMap = new HashMap<Integer, ArrayNode>();
    private ObjectNode rootNode;

    @Override
    public Obs.FinishExplorationNode startExplorationNode(int exporationId, OptionalInt parentLevelId, String humanDescription, int startColumn, Optional<State> incomingState) {
        ObjectNode json = parentLevelId.isPresent() ? this.childrenMap.get(parentLevelId.getAsInt()).addObject() : (this.rootNode = OBJECT_MAPPER.createObjectNode());
        json.put("type", "exploration");
        json.put("id", exporationId);
        parentLevelId.ifPresent(id -> json.put("parentId", id));
        json.put("humanDescription", humanDescription);
        json.put("startColumn", startColumn);
        incomingState.ifPresent(state -> json.set("incomingState", OBJECT_MAPPER.valueToTree(state)));
        this.createChildrenNode(exporationId, json);
        return (parentLevel, newState) -> {
            ObjectNode resultNode = OBJECT_MAPPER.createObjectNode();
            json.set("result", (JsonNode)resultNode);
            resultNode.set("outputLevel", (JsonNode)new JsonDocVisitor(newState).visit(parentLevel));
            resultNode.set("finalState", OBJECT_MAPPER.valueToTree((Object)newState));
        };
    }

    @Override
    public Obs.FinishLevelNode writeLevelNode(int levelNodeId, int parentExplorationId, State incomingState, Level level) {
        ObjectNode json = this.childrenMap.get(parentExplorationId).addObject();
        json.put("type", "level");
        json.put("id", levelNodeId);
        json.put("levelId", level.id());
        json.put("parentId", parentExplorationId);
        json.put("flat", level.getFlat());
        json.put("toString", level.toString());
        json.set("incomingState", OBJECT_MAPPER.valueToTree((Object)incomingState));
        json.set("openOp", OBJECT_MAPPER.valueToTree((Object)level.getOpenOp()));
        json.put("evaluatedIndent", level.getPlusIndent().eval(incomingState));
        this.createChildrenNode(levelNodeId, json);
        return acceptedExplorationId -> json.put("acceptedExplorationId", acceptedExplorationId);
    }

    @Override
    public String getOutput() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this.rootNode);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private void createChildrenNode(int id, ObjectNode json) {
        ArrayNode children = OBJECT_MAPPER.createArrayNode();
        json.set("children", (JsonNode)children);
        this.childrenMap.put(id, children);
    }
}

