/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.java.InputMetadata;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OpsBuilder.OpsOutput", generator="Immutables")
@Immutable
public final class ImmutableOpsOutput
implements OpsBuilder.OpsOutput {
    private final ImmutableList<Op> ops;
    private final InputMetadata inputMetadata;

    private ImmutableOpsOutput(ImmutableList<Op> ops, InputMetadata inputMetadata) {
        this.ops = ops;
        this.inputMetadata = inputMetadata;
    }

    @Override
    public ImmutableList<Op> ops() {
        return this.ops;
    }

    @Override
    public InputMetadata inputMetadata() {
        return this.inputMetadata;
    }

    public final ImmutableOpsOutput withOps(Op ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableOpsOutput((ImmutableList<Op>)newValue, this.inputMetadata);
    }

    public final ImmutableOpsOutput withOps(Iterable<? extends Op> elements) {
        if (this.ops == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableOpsOutput((ImmutableList<Op>)newValue, this.inputMetadata);
    }

    public final ImmutableOpsOutput withInputMetadata(InputMetadata value) {
        if (this.inputMetadata == value) {
            return this;
        }
        InputMetadata newValue = Objects.requireNonNull(value, "inputMetadata");
        return new ImmutableOpsOutput(this.ops, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOpsOutput && this.equalTo(0, (ImmutableOpsOutput)another);
    }

    private boolean equalTo(int synthetic, ImmutableOpsOutput another) {
        return this.ops.equals(another.ops) && this.inputMetadata.equals(another.inputMetadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ops.hashCode();
        h += (h << 5) + this.inputMetadata.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OpsOutput").omitNullValues().add("ops", this.ops).add("inputMetadata", (Object)this.inputMetadata).toString();
    }

    public static OpsBuilder.OpsOutput copyOf(OpsBuilder.OpsOutput instance) {
        if (instance instanceof ImmutableOpsOutput) {
            return (ImmutableOpsOutput)instance;
        }
        return ImmutableOpsOutput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OpsBuilder.OpsOutput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT_METADATA = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Op> ops = ImmutableList.builder();
        @Nullable
        private InputMetadata inputMetadata;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OpsBuilder.OpsOutput instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllOps((Iterable<? extends Op>)instance.ops());
            this.inputMetadata(instance.inputMetadata());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOps(Op element) {
            this.ops.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOps(Op ... elements) {
            this.ops.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ops(Iterable<? extends Op> elements) {
            this.ops = ImmutableList.builder();
            return this.addAllOps(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOps(Iterable<? extends Op> elements) {
            this.ops.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inputMetadata(InputMetadata inputMetadata) {
            this.inputMetadata = Objects.requireNonNull(inputMetadata, "inputMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public OpsBuilder.OpsOutput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOpsOutput((ImmutableList<Op>)this.ops.build(), this.inputMetadata);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("inputMetadata");
            }
            return "Cannot build OpsOutput, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

