/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.palantir.javaformat.Input;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.java.ImmutableInputMetadata;
import com.palantir.javaformat.java.InputMetadata;
import com.palantir.javaformat.java.JavaOutput;
import java.util.HashMap;
import java.util.Map;

public final class InputMetadataBuilder {
    private final Map<Integer, OpsBuilder.BlankLineWanted> blankLines = new HashMap<Integer, OpsBuilder.BlankLineWanted>();
    private final RangeSet<Integer> partialFormatRanges = TreeRangeSet.create();

    public void blankLine(int k, OpsBuilder.BlankLineWanted wanted) {
        if (this.blankLines.containsKey(k)) {
            this.blankLines.put(k, this.blankLines.get(k).merge(wanted));
        } else {
            this.blankLines.put(k, wanted);
        }
    }

    public void markForPartialFormat(Input.Token start, Input.Token end) {
        int lo = JavaOutput.startTok(start).getIndex();
        int hi = JavaOutput.endTok(end).getIndex();
        this.partialFormatRanges.add(Range.closed((Comparable)Integer.valueOf(lo), (Comparable)Integer.valueOf(hi)));
    }

    public InputMetadata build() {
        return ImmutableInputMetadata.builder().blankLines((Map<Integer, ? extends OpsBuilder.BlankLineWanted>)ImmutableMap.copyOf(this.blankLines)).partialFormatRanges((ImmutableRangeSet<Integer>)ImmutableRangeSet.copyOf(this.partialFormatRanges)).build();
    }
}

