/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.NonBreakingSpace;
import com.palantir.javaformat.doc.Token;

public interface DocVisitor<T> {
    default public T visit(Doc doc) {
        if (doc instanceof Level) {
            return this.visitLevel((Level)doc);
        }
        if (doc instanceof Break) {
            return this.visitBreak((Break)doc);
        }
        if (doc instanceof Token) {
            return this.visitToken((Token)doc);
        }
        if (doc instanceof Comment) {
            return this.visitComment((Comment)doc);
        }
        if (doc instanceof NonBreakingSpace) {
            return this.visitSpace((NonBreakingSpace)doc);
        }
        throw new RuntimeException();
    }

    public T visitSpace(NonBreakingSpace var1);

    public T visitComment(Comment var1);

    public T visitToken(Token var1);

    public T visitBreak(Break var1);

    public T visitLevel(Level var1);
}

