/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.CommentsHelper;
import com.palantir.javaformat.FormattingError;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.Utils;
import com.palantir.javaformat.doc.DocBuilder;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.NoopSink;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.java.DebugRenderer;
import com.palantir.javaformat.java.FormatterException;
import com.palantir.javaformat.java.FormatterExceptions;
import com.palantir.javaformat.java.ImportOrderer;
import com.palantir.javaformat.java.JavaCommentsHelper;
import com.palantir.javaformat.java.JavaFormatterOptions;
import com.palantir.javaformat.java.JavaInput;
import com.palantir.javaformat.java.JavaInputAstVisitor;
import com.palantir.javaformat.java.JavaOutput;
import com.palantir.javaformat.java.JsonSink;
import com.palantir.javaformat.java.ModifierOrderer;
import com.palantir.javaformat.java.RemoveUnusedImports;
import com.palantir.javaformat.java.Replacement;
import com.palantir.javaformat.java.StringWrapper;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

@Immutable
public final class Formatter {
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    private final JavaFormatterOptions options;
    private final boolean debugMode;

    @VisibleForTesting
    Formatter(JavaFormatterOptions options, boolean debugMode) {
        this.options = options;
        this.debugMode = debugMode;
    }

    public static Formatter create() {
        return new Formatter(JavaFormatterOptions.defaultOptions(), false);
    }

    public static Formatter createFormatter(JavaFormatterOptions options) {
        return new Formatter(options, false);
    }

    static JavaOutput format(JavaInput javaInput, JavaFormatterOptions options, CommentsHelper commentsHelper, boolean debugMode) throws FormatterException {
        JavaInputAstVisitor visitor;
        Context context = new Context();
        Options.instance(context).put("allowStringFolding", "false");
        JCTree.JCCompilationUnit unit = Formatter.parseJcCompilationUnit(context, javaInput.getText());
        javaInput.setCompilationUnit(unit);
        OpsBuilder opsBuilder = new OpsBuilder(javaInput);
        if (Formatter.getRuntimeVersion() >= 14) {
            try {
                visitor = Class.forName("com.palantir.javaformat.java.java14.Java14InputAstVisitor").asSubclass(JavaInputAstVisitor.class).getConstructor(OpsBuilder.class, Integer.TYPE).newInstance(opsBuilder, options.indentationMultiplier());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            visitor = new JavaInputAstVisitor(opsBuilder, options.indentationMultiplier());
        }
        visitor.scan((Tree)unit, null);
        opsBuilder.sync(javaInput.getText().length());
        opsBuilder.drain();
        OpsBuilder.OpsOutput opsOutput = opsBuilder.build();
        Level doc = new DocBuilder().withOps((List<Op>)opsOutput.ops()).build();
        Obs.Sink sink = debugMode ? new JsonSink() : new NoopSink();
        Obs.ExplorationNode observationNode = Obs.createRoot(sink);
        State finalState = doc.computeBreaks(commentsHelper, options.maxLineLength(), State.startingState(), observationNode);
        JavaOutput javaOutput = new JavaOutput(javaInput, opsOutput.inputMetadata());
        doc.write(finalState, javaOutput);
        javaOutput.flush();
        if (debugMode) {
            DebugRenderer.render(javaInput, opsOutput, doc, finalState, javaOutput, sink.getOutput());
        }
        return javaOutput;
    }

    static JCTree.JCCompilationUnit parseJcCompilationUnit(Context context, final String sourceText) throws FormatterException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("--enable-preview", "true");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, (Iterable<? extends File>)ImmutableList.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return sourceText;
            }
        };
        Log.instance(context).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context);
        JavacParser parser = parserFactory.newParser(sourceText, true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        Iterable errorDiagnostics = Iterables.filter(diagnostics.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            throw FormatterExceptions.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit;
    }

    @VisibleForTesting
    static int getRuntimeVersion() {
        return Runtime.version().feature();
    }

    static boolean errorDiagnostic(Diagnostic<?> input) {
        if (input.getKind() != Diagnostic.Kind.ERROR) {
            return false;
        }
        switch (input.getCode()) {
            case "compiler.err.invalid.meth.decl.ret.type.req": {
                return false;
            }
        }
        return true;
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write((CharSequence)this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        return this.formatSource(input, (Collection<Range<Integer>>)ImmutableList.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(input.length()))));
    }

    public String formatSourceAndFixImports(String input) throws FormatterException {
        input = ImportOrderer.reorderImports(input, this.options.style());
        input = RemoveUnusedImports.removeUnusedImports(input);
        String formatted = this.formatSource(input);
        formatted = StringWrapper.wrap(this.options.maxLineLength(), formatted, this);
        return formatted;
    }

    public String fixImports(String input) throws FormatterException {
        return ImportOrderer.reorderImports(RemoveUnusedImports.removeUnusedImports(input), this.options.style());
    }

    public String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        return Utils.applyReplacements(input, this.getFormatReplacements(input, characterRanges));
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        JavaOutput javaOutput;
        JavaInput javaInput = new JavaInput(input);
        javaInput = ModifierOrderer.reorderModifiers(javaInput, characterRanges);
        JavaCommentsHelper commentsHelper = new JavaCommentsHelper(javaInput.getLineSeparator(), this.options);
        try {
            javaOutput = Formatter.format(javaInput, this.options, commentsHelper, this.debugMode);
        }
        catch (FormattingError e) {
            throw new FormatterException(e.diagnostics());
        }
        RangeSet<Integer> tokenRangeSet = javaInput.characterRangesToTokenRanges(characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }
}

