/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.BreakBehaviour;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.LastLevelBreakability;
import com.palantir.javaformat.OpenOp;
import com.palantir.javaformat.PartialInlineability;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OpenOp", generator="Immutables")
@Immutable
public final class ImmutableOpenOp
extends OpenOp {
    private final Indent plusIndent;
    private final BreakBehaviour breakBehaviour;
    private final LastLevelBreakability breakabilityIfLastLevel;
    private final PartialInlineability partialInlineability;
    private final OpenOp.Complexity complexity;
    @Nullable
    private final String debugName;
    @Nullable
    private final Integer columnLimitBeforeLastBreak;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOpenOp(Builder builder) {
        this.plusIndent = builder.plusIndent;
        this.debugName = builder.debugName;
        this.columnLimitBeforeLastBreak = builder.columnLimitBeforeLastBreak;
        if (builder.breakBehaviour != null) {
            this.initShim.breakBehaviour(builder.breakBehaviour);
        }
        if (builder.breakabilityIfLastLevel != null) {
            this.initShim.breakabilityIfLastLevel(builder.breakabilityIfLastLevel);
        }
        if (builder.partialInlineability != null) {
            this.initShim.partialInlineability(builder.partialInlineability);
        }
        if (builder.complexity != null) {
            this.initShim.complexity(builder.complexity);
        }
        this.breakBehaviour = this.initShim.breakBehaviour();
        this.breakabilityIfLastLevel = this.initShim.breakabilityIfLastLevel();
        this.partialInlineability = this.initShim.partialInlineability();
        this.complexity = this.initShim.complexity();
        this.initShim = null;
    }

    private ImmutableOpenOp(Indent plusIndent, BreakBehaviour breakBehaviour, LastLevelBreakability breakabilityIfLastLevel, PartialInlineability partialInlineability, OpenOp.Complexity complexity, @Nullable String debugName, @Nullable Integer columnLimitBeforeLastBreak) {
        this.plusIndent = plusIndent;
        this.breakBehaviour = breakBehaviour;
        this.breakabilityIfLastLevel = breakabilityIfLastLevel;
        this.partialInlineability = partialInlineability;
        this.complexity = complexity;
        this.debugName = debugName;
        this.columnLimitBeforeLastBreak = columnLimitBeforeLastBreak;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="plusIndent")
    public Indent plusIndent() {
        return this.plusIndent;
    }

    @Override
    @JsonProperty(value="breakBehaviour")
    public BreakBehaviour breakBehaviour() {
        InitShim shim = this.initShim;
        return shim != null ? shim.breakBehaviour() : this.breakBehaviour;
    }

    @Override
    @JsonProperty(value="breakabilityIfLastLevel")
    public LastLevelBreakability breakabilityIfLastLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.breakabilityIfLastLevel() : this.breakabilityIfLastLevel;
    }

    @Override
    @JsonProperty(value="partialInlineability")
    public PartialInlineability partialInlineability() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partialInlineability() : this.partialInlineability;
    }

    @Override
    @JsonProperty(value="complexity")
    public OpenOp.Complexity complexity() {
        InitShim shim = this.initShim;
        return shim != null ? shim.complexity() : this.complexity;
    }

    @Override
    @JsonProperty(value="debugName")
    public Optional<String> debugName() {
        return Optional.ofNullable(this.debugName);
    }

    @Override
    @JsonProperty(value="columnLimitBeforeLastBreak")
    public OptionalInt columnLimitBeforeLastBreak() {
        return this.columnLimitBeforeLastBreak != null ? OptionalInt.of(this.columnLimitBeforeLastBreak) : OptionalInt.empty();
    }

    public final ImmutableOpenOp withPlusIndent(Indent value) {
        if (this.plusIndent == value) {
            return this;
        }
        Indent newValue = Objects.requireNonNull(value, "plusIndent");
        return new ImmutableOpenOp(newValue, this.breakBehaviour, this.breakabilityIfLastLevel, this.partialInlineability, this.complexity, this.debugName, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withBreakBehaviour(BreakBehaviour value) {
        if (this.breakBehaviour == value) {
            return this;
        }
        BreakBehaviour newValue = Objects.requireNonNull(value, "breakBehaviour");
        return new ImmutableOpenOp(this.plusIndent, newValue, this.breakabilityIfLastLevel, this.partialInlineability, this.complexity, this.debugName, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withBreakabilityIfLastLevel(LastLevelBreakability value) {
        LastLevelBreakability newValue = Objects.requireNonNull(value, "breakabilityIfLastLevel");
        if (this.breakabilityIfLastLevel == newValue) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, newValue, this.partialInlineability, this.complexity, this.debugName, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withPartialInlineability(PartialInlineability value) {
        PartialInlineability newValue = Objects.requireNonNull(value, "partialInlineability");
        if (this.partialInlineability == newValue) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, this.breakabilityIfLastLevel, newValue, this.complexity, this.debugName, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withComplexity(OpenOp.Complexity value) {
        OpenOp.Complexity newValue = Objects.requireNonNull(value, "complexity");
        if (this.complexity == newValue) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, this.breakabilityIfLastLevel, this.partialInlineability, newValue, this.debugName, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withDebugName(String value) {
        String newValue = Objects.requireNonNull(value, "debugName");
        if (Objects.equals(this.debugName, newValue)) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, this.breakabilityIfLastLevel, this.partialInlineability, this.complexity, newValue, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withDebugName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.debugName, value)) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, this.breakabilityIfLastLevel, this.partialInlineability, this.complexity, value, this.columnLimitBeforeLastBreak);
    }

    public final ImmutableOpenOp withColumnLimitBeforeLastBreak(int value) {
        Integer newValue = value;
        if (Objects.equals(this.columnLimitBeforeLastBreak, newValue)) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, this.breakabilityIfLastLevel, this.partialInlineability, this.complexity, this.debugName, newValue);
    }

    public final ImmutableOpenOp withColumnLimitBeforeLastBreak(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.columnLimitBeforeLastBreak, value)) {
            return this;
        }
        return new ImmutableOpenOp(this.plusIndent, this.breakBehaviour, this.breakabilityIfLastLevel, this.partialInlineability, this.complexity, this.debugName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOpenOp && this.equalTo(0, (ImmutableOpenOp)another);
    }

    private boolean equalTo(int synthetic, ImmutableOpenOp another) {
        return this.plusIndent.equals(another.plusIndent) && this.breakBehaviour.equals(another.breakBehaviour) && this.breakabilityIfLastLevel.equals((Object)another.breakabilityIfLastLevel) && this.partialInlineability.equals((Object)another.partialInlineability) && this.complexity.equals((Object)another.complexity) && Objects.equals(this.debugName, another.debugName) && Objects.equals(this.columnLimitBeforeLastBreak, another.columnLimitBeforeLastBreak);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.plusIndent.hashCode();
        h += (h << 5) + this.breakBehaviour.hashCode();
        h += (h << 5) + this.breakabilityIfLastLevel.hashCode();
        h += (h << 5) + this.partialInlineability.hashCode();
        h += (h << 5) + this.complexity.hashCode();
        h += (h << 5) + Objects.hashCode(this.debugName);
        h += (h << 5) + Objects.hashCode(this.columnLimitBeforeLastBreak);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OpenOp").omitNullValues().add("plusIndent", (Object)this.plusIndent).add("breakBehaviour", (Object)this.breakBehaviour).add("breakabilityIfLastLevel", (Object)this.breakabilityIfLastLevel).add("partialInlineability", (Object)this.partialInlineability).add("complexity", (Object)this.complexity).add("debugName", (Object)this.debugName).add("columnLimitBeforeLastBreak", (Object)this.columnLimitBeforeLastBreak).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOpenOp fromJson(Json json) {
        OpenOp.Builder builder = new OpenOp.Builder();
        if (json.plusIndent != null) {
            builder.plusIndent(json.plusIndent);
        }
        if (json.breakBehaviour != null) {
            builder.breakBehaviour(json.breakBehaviour);
        }
        if (json.breakabilityIfLastLevel != null) {
            builder.breakabilityIfLastLevel(json.breakabilityIfLastLevel);
        }
        if (json.partialInlineability != null) {
            builder.partialInlineability(json.partialInlineability);
        }
        if (json.complexity != null) {
            builder.complexity(json.complexity);
        }
        if (json.debugName != null) {
            builder.debugName(json.debugName);
        }
        if (json.columnLimitBeforeLastBreak != null) {
            builder.columnLimitBeforeLastBreak(json.columnLimitBeforeLastBreak);
        }
        return builder.build();
    }

    public static ImmutableOpenOp copyOf(OpenOp instance) {
        if (instance instanceof ImmutableOpenOp) {
            return (ImmutableOpenOp)instance;
        }
        return new OpenOp.Builder().from(instance).build();
    }

    @Generated(from="OpenOp", generator="Immutables")
    private final class InitShim {
        private byte breakBehaviourBuildStage = 0;
        private BreakBehaviour breakBehaviour;
        private byte breakabilityIfLastLevelBuildStage = 0;
        private LastLevelBreakability breakabilityIfLastLevel;
        private byte partialInlineabilityBuildStage = 0;
        private PartialInlineability partialInlineability;
        private byte complexityBuildStage = 0;
        private OpenOp.Complexity complexity;

        private InitShim() {
        }

        BreakBehaviour breakBehaviour() {
            if (this.breakBehaviourBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.breakBehaviourBuildStage == 0) {
                this.breakBehaviourBuildStage = (byte)-1;
                this.breakBehaviour = Objects.requireNonNull(ImmutableOpenOp.super.breakBehaviour(), "breakBehaviour");
                this.breakBehaviourBuildStage = 1;
            }
            return this.breakBehaviour;
        }

        void breakBehaviour(BreakBehaviour breakBehaviour) {
            this.breakBehaviour = breakBehaviour;
            this.breakBehaviourBuildStage = 1;
        }

        LastLevelBreakability breakabilityIfLastLevel() {
            if (this.breakabilityIfLastLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.breakabilityIfLastLevelBuildStage == 0) {
                this.breakabilityIfLastLevelBuildStage = (byte)-1;
                this.breakabilityIfLastLevel = Objects.requireNonNull(ImmutableOpenOp.super.breakabilityIfLastLevel(), "breakabilityIfLastLevel");
                this.breakabilityIfLastLevelBuildStage = 1;
            }
            return this.breakabilityIfLastLevel;
        }

        void breakabilityIfLastLevel(LastLevelBreakability breakabilityIfLastLevel) {
            this.breakabilityIfLastLevel = breakabilityIfLastLevel;
            this.breakabilityIfLastLevelBuildStage = 1;
        }

        PartialInlineability partialInlineability() {
            if (this.partialInlineabilityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partialInlineabilityBuildStage == 0) {
                this.partialInlineabilityBuildStage = (byte)-1;
                this.partialInlineability = Objects.requireNonNull(ImmutableOpenOp.super.partialInlineability(), "partialInlineability");
                this.partialInlineabilityBuildStage = 1;
            }
            return this.partialInlineability;
        }

        void partialInlineability(PartialInlineability partialInlineability) {
            this.partialInlineability = partialInlineability;
            this.partialInlineabilityBuildStage = 1;
        }

        OpenOp.Complexity complexity() {
            if (this.complexityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.complexityBuildStage == 0) {
                this.complexityBuildStage = (byte)-1;
                this.complexity = Objects.requireNonNull(ImmutableOpenOp.super.complexity(), "complexity");
                this.complexityBuildStage = 1;
            }
            return this.complexity;
        }

        void complexity(OpenOp.Complexity complexity) {
            this.complexity = complexity;
            this.complexityBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.breakBehaviourBuildStage == -1) {
                attributes.add("breakBehaviour");
            }
            if (this.breakabilityIfLastLevelBuildStage == -1) {
                attributes.add("breakabilityIfLastLevel");
            }
            if (this.partialInlineabilityBuildStage == -1) {
                attributes.add("partialInlineability");
            }
            if (this.complexityBuildStage == -1) {
                attributes.add("complexity");
            }
            return "Cannot build OpenOp, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="OpenOp", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_PLUS_INDENT = 1L;
        private long initBits = 1L;
        @Nullable
        private Indent plusIndent;
        @Nullable
        private BreakBehaviour breakBehaviour;
        @Nullable
        private LastLevelBreakability breakabilityIfLastLevel;
        @Nullable
        private PartialInlineability partialInlineability;
        @Nullable
        private OpenOp.Complexity complexity;
        @Nullable
        private String debugName;
        @Nullable
        private Integer columnLimitBeforeLastBreak;

        public Builder() {
            if (!(this instanceof OpenOp.Builder)) {
                throw new UnsupportedOperationException("Use: new OpenOp.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder from(OpenOp instance) {
            OptionalInt columnLimitBeforeLastBreakOptional;
            Objects.requireNonNull(instance, "instance");
            this.plusIndent(instance.plusIndent());
            this.breakBehaviour(instance.breakBehaviour());
            this.breakabilityIfLastLevel(instance.breakabilityIfLastLevel());
            this.partialInlineability(instance.partialInlineability());
            this.complexity(instance.complexity());
            Optional<String> debugNameOptional = instance.debugName();
            if (debugNameOptional.isPresent()) {
                this.debugName(debugNameOptional);
            }
            if ((columnLimitBeforeLastBreakOptional = instance.columnLimitBeforeLastBreak()).isPresent()) {
                this.columnLimitBeforeLastBreak(columnLimitBeforeLastBreakOptional);
            }
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder plusIndent(Indent plusIndent) {
            this.plusIndent = Objects.requireNonNull(plusIndent, "plusIndent");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder breakBehaviour(BreakBehaviour breakBehaviour) {
            this.breakBehaviour = Objects.requireNonNull(breakBehaviour, "breakBehaviour");
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder breakabilityIfLastLevel(LastLevelBreakability breakabilityIfLastLevel) {
            this.breakabilityIfLastLevel = Objects.requireNonNull(breakabilityIfLastLevel, "breakabilityIfLastLevel");
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder partialInlineability(PartialInlineability partialInlineability) {
            this.partialInlineability = Objects.requireNonNull(partialInlineability, "partialInlineability");
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder complexity(OpenOp.Complexity complexity) {
            this.complexity = Objects.requireNonNull(complexity, "complexity");
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder debugName(String debugName) {
            this.debugName = Objects.requireNonNull(debugName, "debugName");
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder debugName(Optional<String> debugName) {
            this.debugName = debugName.orElse(null);
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder columnLimitBeforeLastBreak(int columnLimitBeforeLastBreak) {
            this.columnLimitBeforeLastBreak = columnLimitBeforeLastBreak;
            return (OpenOp.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OpenOp.Builder columnLimitBeforeLastBreak(OptionalInt columnLimitBeforeLastBreak) {
            this.columnLimitBeforeLastBreak = columnLimitBeforeLastBreak.isPresent() ? Integer.valueOf(columnLimitBeforeLastBreak.getAsInt()) : null;
            return (OpenOp.Builder)this;
        }

        public ImmutableOpenOp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOpenOp(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("plusIndent");
            }
            return "Cannot build OpenOp, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OpenOp", generator="Immutables")
    static final class Json
    extends OpenOp {
        @Nullable
        Indent plusIndent;
        @Nullable
        BreakBehaviour breakBehaviour;
        @Nullable
        LastLevelBreakability breakabilityIfLastLevel;
        @Nullable
        PartialInlineability partialInlineability;
        @Nullable
        OpenOp.Complexity complexity;
        @Nullable
        Optional<String> debugName = Optional.empty();
        @Nullable
        OptionalInt columnLimitBeforeLastBreak = OptionalInt.empty();

        Json() {
        }

        @JsonProperty(value="plusIndent")
        public void setPlusIndent(Indent plusIndent) {
            this.plusIndent = plusIndent;
        }

        @JsonProperty(value="breakBehaviour")
        public void setBreakBehaviour(BreakBehaviour breakBehaviour) {
            this.breakBehaviour = breakBehaviour;
        }

        @JsonProperty(value="breakabilityIfLastLevel")
        public void setBreakabilityIfLastLevel(LastLevelBreakability breakabilityIfLastLevel) {
            this.breakabilityIfLastLevel = breakabilityIfLastLevel;
        }

        @JsonProperty(value="partialInlineability")
        public void setPartialInlineability(PartialInlineability partialInlineability) {
            this.partialInlineability = partialInlineability;
        }

        @JsonProperty(value="complexity")
        public void setComplexity(OpenOp.Complexity complexity) {
            this.complexity = complexity;
        }

        @JsonProperty(value="debugName")
        public void setDebugName(Optional<String> debugName) {
            this.debugName = debugName;
        }

        @JsonProperty(value="columnLimitBeforeLastBreak")
        public void setColumnLimitBeforeLastBreak(OptionalInt columnLimitBeforeLastBreak) {
            this.columnLimitBeforeLastBreak = columnLimitBeforeLastBreak;
        }

        @Override
        public Indent plusIndent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BreakBehaviour breakBehaviour() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LastLevelBreakability breakabilityIfLastLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PartialInlineability partialInlineability() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OpenOp.Complexity complexity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> debugName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalInt columnLimitBeforeLastBreak() {
            throw new UnsupportedOperationException();
        }
    }
}

