/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Objects;

public final class Replacement {
    private final Range<Integer> replaceRange;
    private final String replacementString;

    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        Preconditions.checkArgument((startPosition >= 0 ? 1 : 0) != 0, (Object)"startPosition must be non-negative");
        Preconditions.checkArgument((startPosition <= endPosition ? 1 : 0) != 0, (Object)"startPosition cannot be after endPosition");
        return new Replacement((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)), replaceWith);
    }

    @JsonCreator
    Replacement(@JsonProperty(value="replaceRange") Range<Integer> replaceRange, @JsonProperty(value="replacementString") String replacementString) {
        this.replaceRange = (Range)Preconditions.checkNotNull(replaceRange, (Object)"Null replaceRange");
        this.replacementString = (String)Preconditions.checkNotNull((Object)replacementString, (Object)"Null replacementString");
    }

    public Range<Integer> getReplaceRange() {
        return this.replaceRange;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Replacement) {
            Replacement that = (Replacement)o;
            return this.replaceRange.equals(that.getReplaceRange()) && this.replacementString.equals(that.getReplacementString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.replaceRange, this.replacementString);
    }

    public String toString() {
        return "Replacement{replaceRange=" + String.valueOf(this.replaceRange) + ", replacementString='" + this.replacementString + "'}";
    }
}

