/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.palantir.gradle.gitversion.Git;
import com.palantir.gradle.gitversion.GitVersionArgs;
import com.palantir.gradle.gitversion.VersionDetails;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionDetailsImpl
implements VersionDetails {
    private static final Logger log = LoggerFactory.getLogger(VersionDetailsImpl.class);
    private static final int VERSION_ABBR_LENGTH = 10;
    private Provider<String> description;
    private Provider<Boolean> isClean;
    private Provider<String> gitHashFull;
    private Provider<String> branchName;
    private Provider<String> originUrl;

    VersionDetailsImpl(ProviderFactory providerFactory, File gitDir, GitVersionArgs gitVersionArgs) {
        String projectDir = gitDir.getParent();
        Git git = new Git(new File(projectDir), providerFactory);
        this.description = git.run("describe", "--tags", "--always", "--first-parent", "--abbrev=7", "--match=" + gitVersionArgs.getPrefix() + "*", "HEAD").map(rawDescription -> rawDescription.replaceFirst("^" + gitVersionArgs.getPrefix(), ""));
        this.isClean = git.run("status", "--porcelain").map(String::isEmpty);
        this.gitHashFull = git.run("rev-parse", "HEAD");
        this.branchName = git.run("branch", "--show-current");
        this.originUrl = git.run("config", "remote.origin.url");
    }

    @Override
    public String getVersion() {
        String envVersion = System.getenv("GIT_VERSION");
        if (envVersion != null && !envVersion.isEmpty()) {
            return envVersion;
        }
        if (this.description() == null) {
            return "unspecified";
        }
        return this.description() + (this.isClean() ? "" : ".dirty");
    }

    private boolean isClean() {
        return (Boolean)this.isClean.get();
    }

    private String description() {
        try {
            return Strings.emptyToNull((String)((String)this.description.get()));
        }
        catch (RuntimeException e) {
            log.error("VersionDetailsImpl::getGitHashFull failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean getIsCleanTag() {
        return this.isClean() && this.descriptionIsPlainTag();
    }

    private boolean descriptionIsPlainTag() {
        return !Pattern.matches(".*g.?[0-9a-fA-F]{3,}", this.description());
    }

    @Override
    public int getCommitDistance() {
        if (this.descriptionIsPlainTag()) {
            return 0;
        }
        Matcher match = Pattern.compile("(.*)-([0-9]+)-g.?[0-9a-fA-F]{3,}").matcher(this.description());
        Preconditions.checkState((boolean)match.matches(), (String)"Cannot get commit distance for description: '%s'", (Object)this.description());
        return Integer.parseInt(match.group(2));
    }

    @Override
    public String getLastTag() {
        if (this.descriptionIsPlainTag()) {
            return this.description();
        }
        Matcher match = Pattern.compile("(.*)-([0-9]+)-g.?[0-9a-fA-F]{3,}").matcher(this.description());
        return match.matches() ? match.group(1) : null;
    }

    @Override
    public String getGitHash() throws IOException {
        return this.getGitHashFull().substring(0, 10);
    }

    @Override
    public String getGitHashFull() throws IOException {
        try {
            return (String)this.gitHashFull.get();
        }
        catch (RuntimeException e) {
            log.error("VersionDetailsImpl::getGitHashFull failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getBranchName() {
        try {
            return Strings.emptyToNull((String)((String)this.branchName.get()));
        }
        catch (RuntimeException e) {
            log.error("VersionDetailsImpl::getBranchName failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getOriginUrl() {
        try {
            return Strings.emptyToNull((String)((String)this.originUrl.get()));
        }
        catch (RuntimeException e) {
            log.error("VersionDetailsImpl::getOriginUrl failed", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        try {
            return String.format("VersionDetails(%s, %s, %s, %s, %s)", this.getVersion(), this.getGitHash(), this.getGitHashFull(), this.getBranchName(), this.getIsCleanTag());
        }
        catch (IOException e) {
            return "";
        }
    }
}

