/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.palantir.gradle.gitversion.GitVersionArgs;
import com.palantir.gradle.gitversion.VersionDetails;
import com.palantir.gradle.gitversion.VersionDetailsImpl;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class GitVersionCacheService
implements BuildService<BuildServiceParameters.None> {
    private final ConcurrentMap<String, VersionDetails> versionDetailsMap = new ConcurrentHashMap<String, VersionDetails>();

    @Inject
    protected abstract ProviderFactory getProviderFactory();

    public final String getGitVersion(File project, Object args) {
        return this.getVersionDetails(project, args).getVersion();
    }

    public final VersionDetails getVersionDetails(File project, Object args) {
        File gitDir = GitVersionCacheService.getRootGitDir(project);
        GitVersionArgs gitVersionArgs = GitVersionArgs.fromGroovyClosure(args);
        String key = String.valueOf(gitDir.toPath()) + "|" + gitVersionArgs.getPrefix();
        return this.versionDetailsMap.computeIfAbsent(key, _k -> new VersionDetailsImpl(this.getProviderFactory(), gitDir, gitVersionArgs));
    }

    private static File getRootGitDir(File currentRoot) {
        File gitDir = GitVersionCacheService.scanForRootGitDir(currentRoot);
        if (!gitDir.exists()) {
            throw new IllegalArgumentException("Cannot find '.git' directory");
        }
        return gitDir;
    }

    private static File scanForRootGitDir(File currentRoot) {
        File gitDir = new File(currentRoot, ".git");
        if (gitDir.exists()) {
            return gitDir;
        }
        if (currentRoot.getParentFile() == null) {
            return gitDir;
        }
        return GitVersionCacheService.scanForRootGitDir(currentRoot.getParentFile());
    }

    public static Provider<GitVersionCacheService> getSharedGitVersionCacheService(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("GitVersionCacheService", GitVersionCacheService.class, _spec -> {});
    }
}

