/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.palantir.gradle.gitversion.GitDescribe;
import com.palantir.gradle.gitversion.GitUtils;
import com.palantir.gradle.gitversion.RefWithTagName;
import com.palantir.gradle.gitversion.RefWithTagNameComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JGitDescribe
implements GitDescribe {
    private static final Logger log = LoggerFactory.getLogger(JGitDescribe.class);
    private final Git git;

    JGitDescribe(Git git) {
        this.git = git;
    }

    @Override
    public String describe(String prefix) {
        try {
            ObjectId headObjectId = this.git.getRepository().resolve("HEAD");
            List<String> revs = this.revList(headObjectId);
            Map<String, RefWithTagName> commitHashToTag = JGitDescribe.mapCommitsToTags(this.git);
            for (int depth = 0; depth < revs.size(); ++depth) {
                String exactTag;
                String rev = revs.get(depth);
                if (!commitHashToTag.containsKey(rev) || !(exactTag = commitHashToTag.get(rev).getTag()).startsWith(prefix)) continue;
                return depth == 0 ? exactTag : String.format("%s-%s-g%s", exactTag, depth, GitUtils.abbrevHash(revs.get(0)));
            }
            return GitUtils.abbrevHash(headObjectId.getName());
        }
        catch (IOException | RuntimeException e) {
            log.debug("JGit describe failed", (Throwable)e);
            return null;
        }
    }

    private List<String> revList(ObjectId initialObjectId) throws IOException {
        ArrayList<String> revs = new ArrayList<String>();
        Repository repo = this.git.getRepository();
        try (RevWalk walk = new RevWalk(repo);){
            RevCommit head = walk.parseCommit((AnyObjectId)initialObjectId);
            while (true) {
                revs.add(head.getName());
                RevCommit[] parents = head.getParents();
                if (parents == null) break;
                if (parents.length == 0) {
                    break;
                }
                head = walk.parseCommit((AnyObjectId)parents[0]);
            }
        }
        return revs;
    }

    private static Map<String, RefWithTagName> mapCommitsToTags(Git git) throws IOException {
        RefWithTagNameComparator comparator = new RefWithTagNameComparator(git);
        HashMap<String, RefWithTagName> commitHashToTag = new HashMap<String, RefWithTagName>();
        for (Ref ref : git.getRepository().getRefDatabase().getRefsByPrefix("refs/tags/")) {
            RefWithTagName refWithTagName = new RefWithTagName(ref, ref.getName().substring("refs/tags/".length()));
            ObjectId peeledRef = refWithTagName.getRef().getPeeledObjectId();
            if (peeledRef == null) {
                JGitDescribe.updateCommitHashMap(commitHashToTag, comparator, ref.getObjectId(), refWithTagName);
                continue;
            }
            JGitDescribe.updateCommitHashMap(commitHashToTag, comparator, peeledRef, refWithTagName);
        }
        return commitHashToTag;
    }

    private static void updateCommitHashMap(Map<String, RefWithTagName> map, RefWithTagNameComparator comparator, ObjectId objectId, RefWithTagName ref) {
        String commitHash = objectId.getName();
        if (map.containsKey(commitHash)) {
            if (comparator.compare(ref, map.get(commitHash)) < 0) {
                map.put(commitHash, ref);
            }
        } else {
            map.put(commitHash, ref);
        }
    }
}

