/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.console;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OTableFormatter {
    protected static final String MORE = "...";
    protected static final SimpleDateFormat DEF_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected OPair<String, Boolean> columnSorting = null;
    protected final Map<String, ALIGNMENT> columnAlignment = new HashMap<String, ALIGNMENT>();
    protected final Map<String, Map<String, String>> columnMetadata = new HashMap<String, Map<String, String>>();
    protected final Set<String> columnHidden = new HashSet<String>();
    protected final Set<String> prefixedColumns = new LinkedHashSet<String>(Arrays.asList("#", "@RID", "@CLASS"));
    protected final OTableOutput out;
    protected int maxMultiValueEntries = 10;
    protected int minColumnSize = 4;
    protected int maxWidthSize = 150;
    protected String nullValue = "";
    private boolean leftBorder = true;
    private boolean rightBorder = true;
    private ODocument footer;

    public OTableFormatter(OTableOutput iConsole) {
        this.out = iConsole;
    }

    public void setColumnSorting(String column, boolean ascending) {
        this.columnSorting = new OPair((Comparable)((Object)column), (Object)ascending);
    }

    public void setColumnHidden(String column) {
        this.columnHidden.add(column);
    }

    public void writeRecords(List<? extends OIdentifiable> resultSet, int limit) {
        this.writeRecords(resultSet, limit, null);
    }

    public void writeRecords(List<? extends OIdentifiable> resultSet, int limit, OCallable<Object, OIdentifiable> iAfterDump) {
        Map<String, Integer> columns = this.parseColumns(resultSet, limit);
        if (this.columnSorting != null) {
            Collections.sort(resultSet, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    ODocument doc1 = (ODocument)((OIdentifiable)o1).getRecord();
                    ODocument doc2 = (ODocument)((OIdentifiable)o2).getRecord();
                    Object value1 = doc1.field((String)((Object)OTableFormatter.this.columnSorting.getKey()));
                    Object value2 = doc2.field((String)((Object)OTableFormatter.this.columnSorting.getKey()));
                    boolean ascending = (Boolean)OTableFormatter.this.columnSorting.getValue();
                    int result = value2 == null ? 1 : (value1 == null ? 0 : (value1 instanceof Comparable ? ((Comparable)value1).compareTo(value2) : value1.toString().compareTo(value2.toString())));
                    return ascending ? result : result * -1;
                }
            });
        }
        int fetched = 0;
        for (OIdentifiable oIdentifiable : resultSet) {
            this.dumpRecordInTable(fetched++, oIdentifiable, columns);
            if (iAfterDump != null) {
                iAfterDump.call((Object)oIdentifiable);
            }
            if (limit <= -1 || fetched < limit) continue;
            this.printHeaderLine(columns);
            this.out.onMessage("\nLIMIT EXCEEDED: resultset contains more items not displayed (limit=" + limit + ")", new Object[0]);
            return;
        }
        if (fetched > 0) {
            this.printHeaderLine(columns);
        }
        if (this.footer != null) {
            this.dumpRecordInTable(-1, (OIdentifiable)this.footer, columns);
            this.printHeaderLine(columns);
        }
    }

    public void setColumnAlignment(String column, ALIGNMENT alignment) {
        this.columnAlignment.put(column, alignment);
    }

    public void setColumnMetadata(String columnName, String metadataName, String metadataValue) {
        Map<String, String> metadata = this.columnMetadata.get(columnName);
        if (metadata == null) {
            metadata = new LinkedHashMap<String, String>();
            this.columnMetadata.put(columnName, metadata);
        }
        metadata.put(metadataName, metadataValue);
    }

    public int getMaxWidthSize() {
        return this.maxWidthSize;
    }

    public OTableFormatter setMaxWidthSize(int maxWidthSize) {
        this.maxWidthSize = maxWidthSize;
        return this;
    }

    public int getMaxMultiValueEntries() {
        return this.maxMultiValueEntries;
    }

    public OTableFormatter setMaxMultiValueEntries(int maxMultiValueEntries) {
        this.maxMultiValueEntries = maxMultiValueEntries;
        return this;
    }

    public void dumpRecordInTable(int iIndex, OIdentifiable iRecord, Map<String, Integer> iColumns) {
        if (iIndex == 0) {
            this.printHeader(iColumns);
        }
        ArrayList<String> vargs = new ArrayList<String>();
        try {
            if (iRecord instanceof ODocument) {
                ((ODocument)iRecord).setLazyLoad(false);
            }
            StringBuilder format = new StringBuilder(this.maxWidthSize);
            if (this.leftBorder) {
                format.append('|');
            }
            int i = 0;
            for (Map.Entry<String, Integer> col : iColumns.entrySet()) {
                String columnName = col.getKey();
                int columnWidth = col.getValue();
                if (i++ > 0) {
                    format.append('|');
                }
                format.append("%-" + columnWidth + "s");
                Object value = this.getFieldValue(iIndex, iRecord, columnName);
                String valueAsString = null;
                if (value != null && (valueAsString = value.toString()).length() > columnWidth) {
                    valueAsString = valueAsString.substring(0, columnWidth - 3) + MORE;
                }
                valueAsString = this.formatCell(columnName, columnWidth, valueAsString);
                vargs.add(valueAsString);
            }
            if (this.rightBorder) {
                format.append('|');
            }
            this.out.onMessage("\n" + format.toString(), vargs.toArray());
        }
        catch (Throwable t) {
            this.out.onMessage("%3d|%9s|%s\n", iIndex, iRecord.getIdentity(), "Error on loading record due to: " + t);
        }
    }

    protected String formatCell(String columnName, int columnWidth, String valueAsString) {
        ALIGNMENT alignment;
        if (valueAsString == null) {
            valueAsString = this.nullValue;
        }
        if ((alignment = this.columnAlignment.get(columnName)) != null) {
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case CENTER: {
                    int room = columnWidth - valueAsString.length();
                    if (room <= 1) break;
                    for (int k = 0; k < room / 2; ++k) {
                        valueAsString = " " + valueAsString;
                    }
                    break;
                }
                case RIGHT: {
                    int room = columnWidth - valueAsString.length();
                    if (room <= 0) break;
                    for (int k = 0; k < room; ++k) {
                        valueAsString = " " + valueAsString;
                    }
                    break;
                }
            }
        }
        return valueAsString;
    }

    private Object getFieldValue(int iIndex, OIdentifiable iRecord, String iColumnName) {
        Object value = null;
        if (iColumnName.equals("#")) {
            value = iIndex > -1 ? Integer.valueOf(iIndex) : "";
        } else if (iColumnName.equals("@RID")) {
            value = iRecord.getIdentity().toString();
        } else if (iRecord instanceof ODocument) {
            value = ((ODocument)iRecord).field(iColumnName);
        } else if (iRecord instanceof OBlob) {
            value = "<binary> (size=" + ((OBlob)iRecord).toStream().length + " bytes)";
        } else if (iRecord instanceof OIdentifiable) {
            ORecord rec = iRecord.getRecord();
            if (rec instanceof ODocument) {
                value = ((ODocument)rec).field(iColumnName);
            } else if (rec instanceof OBlob) {
                value = "<binary> (size=" + ((OBlob)rec).toStream().length + " bytes)";
            }
        }
        return OTableFormatter.getPrettyFieldValue(value, this.maxMultiValueEntries);
    }

    public void setNullValue(String s) {
        this.nullValue = s;
    }

    public void setLeftBorder(boolean value) {
        this.leftBorder = value;
    }

    public void setRightBorder(boolean value) {
        this.rightBorder = value;
    }

    public static String getPrettyFieldMultiValue(Iterator<?> iterator, int maxMultiValueEntries) {
        StringBuilder value = new StringBuilder("[");
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= maxMultiValueEntries) {
                if (iterator instanceof OSizeable) {
                    value.append("(size=");
                    value.append(((OSizeable)iterator).size());
                    value.append(")");
                    break;
                }
                value.append("(more)");
                break;
            }
            if (i > 0) {
                value.append(',');
            }
            value.append(OTableFormatter.getPrettyFieldValue(iterator.next(), maxMultiValueEntries));
            ++i;
        }
        value.append("]");
        return value.toString();
    }

    public void setFooter(ODocument footer) {
        this.footer = footer;
    }

    public static Object getPrettyFieldValue(Object value, int multiValueMaxEntries) {
        if (value instanceof OMultiCollectionIterator) {
            value = OTableFormatter.getPrettyFieldMultiValue(((OMultiCollectionIterator)value).iterator(), multiValueMaxEntries);
        } else if (value instanceof ORidBag) {
            value = OTableFormatter.getPrettyFieldMultiValue(((ORidBag)value).rawIterator(), multiValueMaxEntries);
        } else if (value instanceof Iterator) {
            value = OTableFormatter.getPrettyFieldMultiValue((Iterator)value, multiValueMaxEntries);
        } else if (value instanceof Collection) {
            value = OTableFormatter.getPrettyFieldMultiValue(((Collection)value).iterator(), multiValueMaxEntries);
        } else if (value instanceof ORecord) {
            value = ((ORecord)value).getIdentity().equals(ORecordId.EMPTY_RECORD_ID) ? ((ORecord)value).toString() : ((ORecord)value).getIdentity().toString();
        } else if (value instanceof Date) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
            value = db != null ? db.getStorage().getConfiguration().getDateTimeFormatInstance().format((Date)value) : DEF_DATEFORMAT.format((Date)value);
        } else if (value instanceof byte[]) {
            value = "byte[" + ((byte[])value).length + "]";
        }
        return value;
    }

    private void printHeader(Map<String, Integer> iColumns) {
        StringBuilder columnRow = new StringBuilder("\n");
        HashMap<String, StringBuilder> metadataRows = new HashMap<String, StringBuilder>();
        LinkedHashSet<String> allMetadataNames = new LinkedHashSet<String>();
        for (Map.Entry<String, Map<String, String>> entry : this.columnMetadata.entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                allMetadataNames.add(entry2.getKey());
                StringBuilder metadataRow = (StringBuilder)metadataRows.get(entry2.getKey());
                if (metadataRow != null) continue;
                metadataRow = new StringBuilder("\n");
                metadataRows.put(entry2.getKey(), metadataRow);
            }
        }
        this.printHeaderLine(iColumns);
        int i = 0;
        if (this.leftBorder) {
            columnRow.append('|');
            if (!metadataRows.isEmpty()) {
                for (StringBuilder buffer : metadataRows.values()) {
                    buffer.append('|');
                }
            }
        }
        for (Map.Entry<String, Integer> column : iColumns.entrySet()) {
            String colName = column.getKey();
            if (this.columnHidden.contains(colName)) continue;
            if (i > 0) {
                columnRow.append('|');
                if (!metadataRows.isEmpty()) {
                    for (StringBuilder buffer : metadataRows.values()) {
                        buffer.append('|');
                    }
                }
            }
            if (colName.length() > column.getValue()) {
                colName = colName.substring(0, column.getValue());
            }
            columnRow.append(String.format("%-" + column.getValue() + "s", this.formatCell(colName, column.getValue(), colName)));
            if (!metadataRows.isEmpty()) {
                for (String metadataName : allMetadataNames) {
                    String metadataValue;
                    StringBuilder buffer = (StringBuilder)metadataRows.get(metadataName);
                    Map<String, String> metadataColumn = this.columnMetadata.get(column.getKey());
                    String string = metadataValue = metadataColumn != null ? metadataColumn.get(metadataName) : null;
                    if (metadataValue == null) {
                        metadataValue = "";
                    }
                    if (metadataValue.length() > column.getValue()) {
                        metadataValue = metadataValue.substring(0, column.getValue());
                    }
                    buffer.append(String.format("%-" + column.getValue() + "s", this.formatCell(colName, column.getValue(), metadataValue)));
                }
            }
            ++i;
        }
        if (this.rightBorder) {
            columnRow.append('|');
            if (!metadataRows.isEmpty()) {
                for (StringBuilder buffer : metadataRows.values()) {
                    buffer.append('|');
                }
            }
        }
        if (!metadataRows.isEmpty()) {
            for (StringBuilder buffer : metadataRows.values()) {
                this.out.onMessage(buffer.toString(), new Object[0]);
            }
            this.printHeaderLine(iColumns);
        }
        this.out.onMessage(columnRow.toString(), new Object[0]);
        this.printHeaderLine(iColumns);
    }

    private void printHeaderLine(Map<String, Integer> iColumns) {
        StringBuilder buffer = new StringBuilder("\n");
        if (iColumns.size() > 0) {
            if (this.leftBorder) {
                buffer.append('+');
            }
            int i = 0;
            for (Map.Entry<String, Integer> column : iColumns.entrySet()) {
                String colName = column.getKey();
                if (this.columnHidden.contains(colName)) continue;
                if (i++ > 0) {
                    buffer.append("+");
                }
                for (int k = 0; k < column.getValue(); ++k) {
                    buffer.append("-");
                }
            }
            if (this.rightBorder) {
                buffer.append('+');
            }
        }
        this.out.onMessage(buffer.toString(), new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> parseColumns(Collection<? extends OIdentifiable> resultSet, int limit) {
        LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>();
        for (String c : this.prefixedColumns) {
            columns.put(c, this.minColumnSize);
        }
        boolean tempRids = false;
        boolean hasClass = false;
        int fetched = 0;
        for (OIdentifiable oIdentifiable : resultSet) {
            ORecord oRecord = oIdentifiable.getRecord();
            for (String string : this.prefixedColumns) {
                columns.put(string, this.getColumnSize(fetched, oRecord, string, (Integer)columns.get(string)));
            }
            if (oRecord instanceof ODocument) {
                ((ODocument)oRecord).setLazyLoad(false);
                ODocument oDocument = (ODocument)oRecord;
                for (String fieldName : oDocument.fieldNames()) {
                    columns.put(fieldName, this.getColumnSize(fetched, (ORecord)oDocument, fieldName, (Integer)columns.get(fieldName)));
                }
                if (!hasClass && oDocument.getClassName() != null) {
                    hasClass = true;
                }
            } else if (oRecord instanceof OBlob) {
                columns.put("value", this.maxWidthSize - 15);
            }
            if (!tempRids && !oRecord.getIdentity().isPersistent()) {
                tempRids = true;
            }
            if (limit <= -1 || fetched++ < limit) continue;
            break;
        }
        if (tempRids) {
            columns.remove("@RID");
        }
        if (!hasClass) {
            columns.remove("@CLASS");
        }
        if (this.footer != null) {
            void var9_19;
            this.footer.setLazyLoad(false);
            String[] stringArray = this.footer.fieldNames();
            int n = stringArray.length;
            boolean bl = false;
            while (var9_19 < n) {
                String string = stringArray[var9_19];
                columns.put(string, this.getColumnSize(fetched, (ORecord)this.footer, string, (Integer)columns.get(string)));
                ++var9_19;
            }
        }
        int width = 0;
        for (Map.Entry entry : columns.entrySet()) {
            width += ((Integer)entry.getValue()).intValue();
        }
        if (width > this.maxWidthSize) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(columns.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            Collections.reverse(arrayList);
            while (width > this.maxWidthSize) {
                int n = width;
                for (Map.Entry entry : arrayList) {
                    int redux = (Integer)entry.getValue() * 10 / 100;
                    if ((Integer)entry.getValue() - redux < this.minColumnSize) break;
                    entry.setValue((Integer)entry.getValue() - redux);
                    if ((width -= redux) > this.maxWidthSize) continue;
                    break;
                }
                if (width != n) continue;
                break;
            }
            columns.clear();
            for (String string : this.prefixedColumns) {
                columns.put(string, this.minColumnSize);
            }
            Collections.reverse(arrayList);
            for (Map.Entry entry : arrayList) {
                columns.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (tempRids) {
            columns.remove("@RID");
        }
        if (!hasClass) {
            columns.remove("@CLASS");
        }
        for (String string : this.columnHidden) {
            columns.remove(string);
        }
        return columns;
    }

    private Integer getColumnSize(Integer iIndex, ORecord iRecord, String fieldName, Integer origSize) {
        String fieldValueAsString;
        Object fieldValue;
        Integer newColumnSize = origSize == null ? Integer.valueOf(fieldName.length()) : Integer.valueOf(Math.max(origSize, fieldName.length()));
        Map<String, String> metadata = this.columnMetadata.get(fieldName);
        if (metadata != null) {
            for (String v : metadata.values()) {
                if (v == null || v.length() <= newColumnSize) continue;
                newColumnSize = v.length();
            }
        }
        if ((fieldValue = this.getFieldValue(iIndex, (OIdentifiable)iRecord, fieldName)) != null && (fieldValueAsString = fieldValue.toString()).length() > newColumnSize) {
            newColumnSize = fieldValueAsString.length();
        }
        if (newColumnSize < this.minColumnSize) {
            newColumnSize = this.minColumnSize;
        }
        return newColumnSize;
    }

    public static interface OTableOutput {
        public void onMessage(String var1, Object ... var2);
    }

    public static enum ALIGNMENT {
        LEFT,
        CENTER,
        RIGHT;

    }
}

