/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security.authenticator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.security.OSecurityAuthenticatorAbstract;

public class OSystemUserAuthenticator
extends OSecurityAuthenticatorAbstract {
    @Override
    public void active() {
        OLogManager.instance().info((Object)this, "OSystemUserAuthenticator is active", new Object[0]);
    }

    @Override
    public void config(OServer oServer, OServerConfigurationManager serverCfg, ODocument jsonConfig) {
        super.config(oServer, serverCfg, jsonConfig);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String authenticate(String username, String password) {
        String principal = null;
        try {
            OUser user;
            if (this.getServer() != null && (user = this.getServer().getSecurity().getSystemUser(username, null)) != null && user.getAccountStatus() == OSecurityUser.STATUSES.ACTIVE && user.checkPassword(password)) {
                principal = username;
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "authenticate()", (Throwable)ex, new Object[0]);
        }
        return principal;
    }

    @Override
    public boolean isAuthorized(String username, String resource) {
        if (username == null || resource == null) {
            return false;
        }
        try {
            OUser user;
            if (this.getServer() != null && (user = this.getServer().getSecurity().getSystemUser(username, null)) != null && user.getAccountStatus() == OSecurityUser.STATUSES.ACTIVE) {
                ORole role = null;
                ORule.ResourceGeneric rg = ORule.mapLegacyResourceToGenericResource((String)resource);
                if (rg != null) {
                    String specificResource = ORule.mapLegacyResourceToSpecificResource((String)resource);
                    if (specificResource == null || specificResource.equals("*")) {
                        specificResource = null;
                    }
                    role = user.checkIfAllowed(rg, specificResource, ORole.PERMISSION_EXECUTE);
                }
                return role != null;
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "isAuthorized()", (Throwable)ex, new Object[0]);
        }
        return false;
    }

    @Override
    public OServerUserConfiguration getUser(String username) {
        OServerUserConfiguration userCfg = null;
        try {
            OUser user;
            if (this.getServer() != null && (user = this.getServer().getSecurity().getSystemUser(username, null)) != null && user.getAccountStatus() == OSecurityUser.STATUSES.ACTIVE) {
                userCfg = new OServerUserConfiguration(user.getName(), "", "");
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "getUser()", (Throwable)ex, new Object[0]);
        }
        return userCfg;
    }
}

