/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ODistributedRequest {
    private final ODistributedServerManager manager;
    private ODistributedRequestId id;
    private String databaseName;
    private long senderThreadId;
    private ORemoteTask task;
    private ORecordId userRID;

    public ODistributedRequest(ODistributedServerManager manager) {
        this.manager = manager;
    }

    public ODistributedRequest(ODistributedServerManager manager, int senderNodeId, long msgSequence, String databaseName, ORemoteTask payload) {
        this.manager = manager;
        this.id = new ODistributedRequestId(senderNodeId, msgSequence);
        this.databaseName = databaseName;
        this.senderThreadId = Thread.currentThread().getId();
        this.task = payload;
    }

    public ODistributedRequestId getId() {
        return this.id;
    }

    public void setId(ODistributedRequestId reqId) {
        this.id = reqId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ODistributedRequest setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public ORemoteTask getTask() {
        return this.task;
    }

    public ODistributedRequest setTask(ORemoteTask payload) {
        this.task = payload;
        return this;
    }

    public ORecordId getUserRID() {
        return this.userRID;
    }

    public void setUserRID(ORecordId iUserRID) {
        this.userRID = iUserRID;
    }

    public void toStream(DataOutput out) throws IOException {
        this.id.toStream(out);
        out.writeLong(this.senderThreadId);
        out.writeUTF(this.databaseName != null ? this.databaseName : "");
        out.writeByte(this.task.getFactoryId());
        this.task.toStream(out);
        if (this.userRID != null) {
            out.writeBoolean(true);
            this.userRID.toStream(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void fromStream(DataInput in) throws IOException {
        this.id = new ODistributedRequestId();
        this.id.fromStream(in);
        this.senderThreadId = in.readLong();
        this.databaseName = in.readUTF();
        if (this.databaseName.isEmpty()) {
            this.databaseName = null;
        }
        ORemoteTaskFactory taskFactory = this.manager.getTaskFactoryManager().getFactoryByServerId(this.id.getNodeId());
        this.task = taskFactory.createTask(in.readByte());
        this.task.fromStream(in, taskFactory);
        if (in.readBoolean()) {
            this.userRID = new ORecordId();
            this.userRID.fromStream(in);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("id=");
        buffer.append(this.id);
        if (this.task != null) {
            buffer.append(" task=");
            buffer.append(this.task.toString());
        }
        if (this.userRID != null) {
            buffer.append(" user=");
            buffer.append(this.userRID);
        }
        return buffer.toString();
    }

    public static enum EXECUTION_MODE {
        RESPONSE,
        NO_RESPONSE;

    }
}

