/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.entity;

import com.orientechnologies.orient.core.entity.OEntityManagerClassHandler;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OObjectEntityClassHandler
extends OEntityManagerClassHandler {
    private static final ConcurrentMap<String, OObjectEntityClassHandler> instances = new ConcurrentHashMap<String, OObjectEntityClassHandler>();

    public void registerEntityClass(Class<?> iClass) {
        this.registerEntityClass(iClass, true);
    }

    public synchronized void registerEntityClass(Class<?> iClass, boolean forceSchemaReload) {
        if (!OObjectEntitySerializer.isToSerialize(iClass) && !iClass.isEnum()) {
            this.registerEntityClass(iClass.getSimpleName(), iClass, forceSchemaReload);
        }
    }

    public synchronized void registerEntityClass(String iClassName, Class<?> iClass) {
        this.registerEntityClass(iClassName, iClass, true);
    }

    public synchronized void registerEntityClass(String iClassName, Class<?> iClass, boolean forceSchemaReload) {
        if (!OObjectEntitySerializer.isToSerialize(iClass) && !iClass.isEnum()) {
            OObjectEntitySerializer.registerClass(iClass, forceSchemaReload);
            super.registerEntityClass(iClassName, iClass, forceSchemaReload);
        }
    }

    public synchronized void deregisterEntityClass(Class<?> iClass) {
        if (!OObjectEntitySerializer.isToSerialize(iClass) && !iClass.isEnum()) {
            OObjectEntitySerializer.deregisterClass(iClass);
            super.deregisterEntityClass(iClass);
        }
    }

    public static OObjectEntityClassHandler getInstance(String url) {
        OObjectEntityClassHandler classHandler = (OObjectEntityClassHandler)((Object)instances.get(url));
        if (classHandler != null) {
            return classHandler;
        }
        classHandler = new OObjectEntityClassHandler();
        OObjectEntityClassHandler oldClassHandler = instances.putIfAbsent(url, classHandler);
        if (oldClassHandler != null) {
            classHandler = oldClassHandler;
        }
        return classHandler;
    }
}

